/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.ssh;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.ndviet.library.ssh.SshConnection;
import org.ndviet.library.ssh.SshResponse;
import org.ndviet.library.ssh.SshTimeoutException;

public final class SshUtils {
    private SshUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshResponse runCommand(SshConnection conn, String cmd, long timeout) throws SshTimeoutException, IOException {
        SshClient client = SshClient.setUpDefaultClient();
        try {
            client.start();
            ConnectFuture cf = client.connect(conn.getUsername(), conn.getHostname(), conn.getPort());
            ClientSession session = (ClientSession)((ConnectFuture)cf.verify()).getSession();
            session.addPasswordIdentity(conn.getPassword());
            session.auth().verify(TimeUnit.SECONDS.toMillis(timeout));
            ChannelExec ce = session.createExecChannel(cmd);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            ce.setOut((OutputStream)out);
            ce.setErr((OutputStream)err);
            ce.open();
            Set events = ce.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), TimeUnit.SECONDS.toMillis(timeout));
            session.close(false);
            if (events.contains(ClientChannelEvent.TIMEOUT)) {
                throw new SshTimeoutException(cmd, conn.getHostname(), timeout);
            }
            List status = IOUtils.readLines((InputStream)new ByteArrayInputStream(out.toByteArray()));
            status.addAll(IOUtils.readLines((InputStream)new ByteArrayInputStream(err.toByteArray())));
            SshResponse sshResponse = new SshResponse(out.toString(), err.toString(), SshUtils.join(status), ce.getExitStatus());
            return sshResponse;
        }
        finally {
            client.stop();
        }
    }

    public static String join(List<String> status) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> statusIterator = status.iterator();
        while (statusIterator.hasNext()) {
            builder.append(statusIterator.next());
            if (!statusIterator.hasNext()) continue;
            builder.append("\n");
        }
        String IGNORE_JDK_WARNING = "OpenJDK 64-Bit Server VM warning: If the number of processors is expected to increase from one, then you should configure the number of parallel GC threads appropriately using -XX:ParallelGCThreads=N";
        int start = builder.indexOf(IGNORE_JDK_WARNING);
        if (start >= 0) {
            builder.delete(start, start + IGNORE_JDK_WARNING.length());
        }
        return builder.toString();
    }
}

