/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.ndviet.library.configuration.AbstractConfiguration;
import org.ndviet.library.configuration.IConfiguration;
import org.ndviet.library.configuration.JsonConfiguration;
import org.ndviet.library.configuration.PropertiesConfiguration;
import org.ndviet.library.configuration.YamlConfiguration;

public class ConfigurationOrdering
implements IConfiguration {
    private List<AbstractConfiguration> m_configurations = new ArrayList<AbstractConfiguration>();

    public ConfigurationOrdering(String baseConfigFile, List<String> orderingConfigFiles) throws Exception {
        this.setConfig(this.initializeConfiguration(null));
        for (int i = orderingConfigFiles.size() - 1; i >= 0; --i) {
            this.setConfig(this.initializeConfiguration(orderingConfigFiles.get(i)));
        }
        this.setConfig(this.initializeConfiguration(baseConfigFile));
    }

    private void setConfig(AbstractConfiguration configuration) {
        if (configuration != null) {
            this.m_configurations.add(configuration);
        }
    }

    private AbstractConfiguration initializeConfiguration(String configFilePath) throws Exception {
        AbstractConfiguration configuration;
        if (configFilePath == null) {
            configuration = new PropertiesConfiguration();
            configuration.readConfigurationFrom(configFilePath);
        } else {
            String fileExtension = configFilePath.substring(configFilePath.lastIndexOf(".") + 1);
            if (fileExtension.equalsIgnoreCase("yml") || fileExtension.equalsIgnoreCase("yaml")) {
                configuration = new YamlConfiguration();
            } else if (fileExtension.equalsIgnoreCase("json")) {
                configuration = new JsonConfiguration();
            } else if (fileExtension.equalsIgnoreCase("properties")) {
                configuration = new PropertiesConfiguration();
            } else {
                throw new RuntimeException("Configuration file type is not support!");
            }
            configuration.readConfigurationFrom(configFilePath);
        }
        return configuration;
    }

    @Override
    public String getValue(String key) {
        AbstractConfiguration configuration;
        String value = null;
        Iterator<AbstractConfiguration> iterator = this.m_configurations.iterator();
        while ((value = (configuration = iterator.next()).getValue(key)) == null && iterator.hasNext()) {
        }
        return value;
    }

    @Override
    public List getListValues(String key) {
        AbstractConfiguration configuration;
        List values = null;
        Iterator<AbstractConfiguration> iterator = this.m_configurations.iterator();
        while ((values = (configuration = iterator.next()).getListValues(key)) == null && iterator.hasNext()) {
        }
        return values;
    }

    @Override
    public LinkedHashMap getMapValues(String key) {
        AbstractConfiguration configuration;
        LinkedHashMap values = null;
        Iterator<AbstractConfiguration> iterator = this.m_configurations.iterator();
        while ((values = (configuration = iterator.next()).getMapValues(key)) == null && iterator.hasNext()) {
        }
        return values;
    }
}

