/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.list;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ndviet.library.math.MathHelpers;

public class ListHelpers {
    private static final Logger LOGGER = LogManager.getLogger(ListHelpers.class);

    public static Object getLastElement(List list, boolean reverse) {
        LOGGER.info("List contains these element: " + list.toString());
        if (reverse) {
            Collections.reverse(list);
        }
        return list.get(list.size() - 1);
    }

    public static <V extends Comparable> boolean isSorted(List<V> list, boolean reverse) {
        LOGGER.info("List contains these element: " + list.toString());
        if (list.isEmpty() || list.size() == 1) {
            return true;
        }
        if (reverse) {
            Collections.reverse(list);
        }
        Iterator<V> iterator = list.iterator();
        Comparable previous = (Comparable)iterator.next();
        while (iterator.hasNext()) {
            Comparable current = (Comparable)iterator.next();
            if (MathHelpers.isCreatable(previous.toString()) && MathHelpers.isCreatable(current.toString())) {
                if (MathHelpers.compareNumber(previous.toString(), current.toString()) > 0) {
                    LOGGER.error("Unsorted pair: " + previous + " - " + current);
                    return false;
                }
            } else if (previous.compareTo(current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }
}

