/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.interfaces.ECKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.OptionalFeature;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestFactory;
import org.apache.sshd.common.keyprovider.KeySizeIndicator;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum ECCurves implements KeyTypeIndicator,
KeySizeIndicator,
NamedResource,
OptionalFeature
{
    nistp256("nistp256", new int[]{1, 2, 840, 10045, 3, 1, 7}, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF", 16)), new BigInteger("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", 16), new BigInteger("5ac635d8aa3a93e7b3ebbd55769886bc651d06b0cc53b0f63bce3c3e27d2604b", 16)), new ECPoint(new BigInteger("6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", 16), new BigInteger("4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", 16)), new BigInteger("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 16), 1), 32, BuiltinDigests.sha256),
    nistp384("nistp384", new int[]{1, 3, 132, 0, 34}, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFF", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", 16), new BigInteger("B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", 16)), new ECPoint(new BigInteger("AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", 16), new BigInteger("3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", 16)), new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973", 16), 1), 48, BuiltinDigests.sha384),
    nistp521("nistp521", new int[]{1, 3, 132, 0, 35}, new ECParameterSpec(new EllipticCurve(new ECFieldFp(new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16)), new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", 16), new BigInteger("0051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", 16)), new ECPoint(new BigInteger("00C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", 16), new BigInteger("011839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", 16)), new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA51868783BF2F966B7FCC0148F709A5D03BB5C9B8899C47AEBB6FB71E91386409", 16), 1), 66, BuiltinDigests.sha512);

    public static final Set<ECCurves> VALUES;
    public static final NavigableSet<String> NAMES;
    public static final NavigableSet<String> KEY_TYPES;
    public static final Comparator<ECCurves> BY_KEY_SIZE;
    public static final List<ECCurves> SORTED_KEY_SIZE;
    private final String name;
    private final String keyType;
    private final String oidString;
    private final List<Integer> oidValue;
    private final ECParameterSpec params;
    private final int keySize;
    private final int numOctets;
    private final DigestFactory digestFactory;

    private ECCurves(String name, int[] oid, ECParameterSpec params, int numOctets, DigestFactory digestFactory) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No curve name");
        this.oidString = NumberUtils.join('.', ValidateUtils.checkNotNullAndNotEmpty(oid, "No OID"));
        this.oidValue = Collections.unmodifiableList(NumberUtils.asList(oid));
        this.keyType = "ecdsa-sha2-" + name;
        this.params = ValidateUtils.checkNotNull(params, "No EC params for %s", (Object)name);
        this.keySize = ECCurves.getCurveSize(params);
        this.numOctets = numOctets;
        this.digestFactory = Objects.requireNonNull(digestFactory, "No digestFactory");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getOID() {
        return this.oidString;
    }

    public final List<Integer> getOIDValue() {
        return this.oidValue;
    }

    @Override
    public final String getKeyType() {
        return this.keyType;
    }

    @Override
    public final boolean isSupported() {
        return SecurityUtils.isECCSupported() && this.digestFactory.isSupported();
    }

    public final ECParameterSpec getParameters() {
        return this.params;
    }

    @Override
    public final int getKeySize() {
        return this.keySize;
    }

    public final int getNumPointOctets() {
        return this.numOctets;
    }

    public final Digest getDigestForParams() {
        return (Digest)this.digestFactory.create();
    }

    public static ECCurves fromKeyType(String type) {
        if (GenericUtils.isEmpty(type)) {
            return null;
        }
        for (ECCurves c : VALUES) {
            if (!type.equalsIgnoreCase(c.getKeyType())) continue;
            return c;
        }
        return null;
    }

    public static ECCurves fromCurveName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ECCurves fromECKey(ECKey key) {
        return ECCurves.fromCurveParameters(key == null ? null : key.getParams());
    }

    public static ECCurves fromCurveParameters(ECParameterSpec params) {
        if (params == null) {
            return null;
        }
        return ECCurves.fromCurveSize(ECCurves.getCurveSize(params));
    }

    public static ECCurves fromCurveSize(int keySize) {
        if (keySize <= 0) {
            return null;
        }
        for (ECCurves c : VALUES) {
            if (keySize != c.getKeySize()) continue;
            return c;
        }
        return null;
    }

    public static ECCurves fromOIDValue(List<? extends Number> oid) {
        if (GenericUtils.isEmpty(oid)) {
            return null;
        }
        for (ECCurves c : VALUES) {
            List<Integer> v = c.getOIDValue();
            if (oid.size() != v.size()) continue;
            boolean matches = true;
            for (int index = 0; index < v.size(); ++index) {
                Number exp = v.get(index);
                Number act = oid.get(index);
                if (exp.intValue() == act.intValue()) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return c;
        }
        return null;
    }

    public static ECCurves fromOID(String oid) {
        if (GenericUtils.isEmpty(oid)) {
            return null;
        }
        for (ECCurves c : VALUES) {
            if (!oid.equalsIgnoreCase(c.getOID())) continue;
            return c;
        }
        return null;
    }

    public static int getCurveSize(ECParameterSpec params) {
        EllipticCurve curve = Objects.requireNonNull(params, "No EC params").getCurve();
        ECField field = Objects.requireNonNull(curve, "No EC curve").getField();
        return Objects.requireNonNull(field, "No EC field").getFieldSize();
    }

    public static byte[] encodeECPoint(ECPoint group, ECParameterSpec params) {
        return ECCurves.encodeECPoint(group, params.getCurve());
    }

    public static byte[] encodeECPoint(ECPoint group, EllipticCurve curve) {
        int elementSize = (curve.getField().getFieldSize() + 7) / 8;
        byte[] m3 = new byte[2 * elementSize + 1];
        m3[0] = 4;
        byte[] affineX = ECCurves.removeLeadingZeroes(group.getAffineX().toByteArray());
        System.arraycopy(affineX, 0, m3, 1 + elementSize - affineX.length, affineX.length);
        byte[] affineY = ECCurves.removeLeadingZeroes(group.getAffineY().toByteArray());
        System.arraycopy(affineY, 0, m3, 1 + elementSize + elementSize - affineY.length, affineY.length);
        return m3;
    }

    private static byte[] removeLeadingZeroes(byte[] input) {
        int pos;
        if (input[0] != 0) {
            return input;
        }
        for (pos = 1; pos < input.length - 1 && input[pos] == 0; ++pos) {
        }
        byte[] output = new byte[input.length - pos];
        System.arraycopy(input, pos, output, 0, output.length);
        return output;
    }

    public static BigInteger octetStringToInteger(byte ... octets) {
        if (octets == null) {
            return null;
        }
        if (octets.length == 0) {
            return BigInteger.ZERO;
        }
        return new BigInteger(1, octets);
    }

    public static ECPoint octetStringToEcPoint(byte ... octets) {
        if (NumberUtils.isEmpty(octets)) {
            return null;
        }
        int startIndex = ECCurves.findFirstNonZeroIndex(octets);
        if (startIndex < 0) {
            throw new IllegalArgumentException("All zeroes ECPoint N/A");
        }
        byte indicator = octets[startIndex];
        ECPointCompression compression = ECPointCompression.fromIndicatorValue(indicator);
        if (compression == null) {
            throw new UnsupportedOperationException("Unknown compression indicator value: 0x" + Integer.toHexString(indicator & 0xFF));
        }
        return compression.octetStringToEcPoint(octets, startIndex + 1, octets.length - startIndex - 1);
    }

    private static int findFirstNonZeroIndex(byte ... octets) {
        if (NumberUtils.isEmpty(octets)) {
            return -1;
        }
        for (int index = 0; index < octets.length; ++index) {
            if (octets[index] == 0) continue;
            return index;
        }
        return -1;
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(ECCurves.class));
        NAMES = Collections.unmodifiableNavigableSet(GenericUtils.mapSort(VALUES, ECCurves::getName, String.CASE_INSENSITIVE_ORDER));
        KEY_TYPES = Collections.unmodifiableNavigableSet(GenericUtils.mapSort(VALUES, ECCurves::getKeyType, String.CASE_INSENSITIVE_ORDER));
        BY_KEY_SIZE = (o1, o2) -> {
            int k1 = o1 == null ? Integer.MAX_VALUE : o1.getKeySize();
            int k2 = o2 == null ? Integer.MAX_VALUE : o2.getKeySize();
            return Integer.compare(k1, k2);
        };
        SORTED_KEY_SIZE = Collections.unmodifiableList(VALUES.stream().sorted(BY_KEY_SIZE).collect(Collectors.toList()));
    }

    public static final class Constants {
        public static final String ECDSA_SHA2_PREFIX = "ecdsa-sha2-";
        public static final String NISTP256 = "nistp256";
        public static final String NISTP384 = "nistp384";
        public static final String NISTP521 = "nistp521";

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }

    public static enum ECPointCompression {
        VARIANT2(2){

            @Override
            public ECPoint octetStringToEcPoint(byte[] octets, int startIndex, int len) {
                byte[] xp = new byte[len];
                System.arraycopy(octets, startIndex, xp, 0, len);
                BigInteger x = ECCurves.octetStringToInteger(xp);
                throw new UnsupportedOperationException("octetStringToEcPoint(" + this.name() + ")(X=" + x + ") compression support N/A");
            }
        }
        ,
        VARIANT3(3){

            @Override
            public ECPoint octetStringToEcPoint(byte[] octets, int startIndex, int len) {
                byte[] xp = new byte[len];
                System.arraycopy(octets, startIndex, xp, 0, len);
                BigInteger x = ECCurves.octetStringToInteger(xp);
                throw new UnsupportedOperationException("octetStringToEcPoint(" + this.name() + ")(X=" + x + ") compression support N/A");
            }
        }
        ,
        UNCOMPRESSED(4){

            @Override
            public ECPoint octetStringToEcPoint(byte[] octets, int startIndex, int len) {
                int numElements = len / 2;
                if (len != numElements * 2) {
                    throw new IllegalArgumentException("octetStringToEcPoint(" + this.name() + ")  invalid remainder octets representation:  expected=" + 2 * numElements + ", actual=" + len);
                }
                byte[] xp = new byte[numElements];
                byte[] yp = new byte[numElements];
                System.arraycopy(octets, startIndex, xp, 0, numElements);
                System.arraycopy(octets, startIndex + numElements, yp, 0, numElements);
                BigInteger x = ECCurves.octetStringToInteger(xp);
                BigInteger y = ECCurves.octetStringToInteger(yp);
                return new ECPoint(x, y);
            }

            @Override
            public void writeECPoint(OutputStream s2, String curveName, ECPoint p) throws IOException {
                ECCurves curve = ECCurves.fromCurveName(curveName);
                if (curve == null) {
                    throw new StreamCorruptedException("writeECPoint(" + this.name() + ")[" + curveName + "] cannot determine octets count");
                }
                int numElements = curve.getNumPointOctets();
                KeyEntryResolver.encodeInt(s2, 1 + 2 * numElements);
                s2.write(this.getIndicatorValue());
                this.writeCoordinate(s2, "X", p.getAffineX(), numElements);
                this.writeCoordinate(s2, "Y", p.getAffineY(), numElements);
            }
        };

        public static final Set<ECPointCompression> VALUES;
        private final byte indicatorValue;

        private ECPointCompression(byte indicator) {
            this.indicatorValue = indicator;
        }

        public final byte getIndicatorValue() {
            return this.indicatorValue;
        }

        public abstract ECPoint octetStringToEcPoint(byte[] var1, int var2, int var3);

        public byte[] ecPointToOctetString(String curveName, ECPoint p) {
            byte[] byArray;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(196);
            try {
                this.writeECPoint(baos, curveName, p);
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("ecPointToOctetString(" + curveName + ") failed (" + e.getClass().getSimpleName() + ") to write data: " + e.getMessage(), e);
                }
            }
            baos.close();
            return byArray;
        }

        public void writeECPoint(OutputStream s2, String curveName, ECPoint p) throws IOException {
            if (s2 == null) {
                throw new EOFException("No output stream");
            }
            throw new StreamCorruptedException("writeECPoint(" + this.name() + ")[" + p + "] N/A");
        }

        protected void writeCoordinate(OutputStream s2, String n, BigInteger v, int numElements) throws IOException {
            byte[] vp = v.toByteArray();
            int startIndex = 0;
            int vLen = vp.length;
            if (vLen > numElements && vp[0] == 0) {
                ++startIndex;
                --vLen;
            }
            if (vLen > numElements) {
                throw new StreamCorruptedException("writeCoordinate(" + this.name() + ")[" + n + "] value length (" + vLen + ") exceeds max. (" + numElements + ") for " + v);
            }
            if (vLen < numElements) {
                byte[] tmp = new byte[numElements];
                System.arraycopy(vp, startIndex, tmp, numElements - vLen, vLen);
                vp = tmp;
                startIndex = 0;
                vLen = vp.length;
            }
            s2.write(vp, startIndex, vLen);
        }

        public static ECPointCompression fromIndicatorValue(int value) {
            if (value < 0 || value > 255) {
                return null;
            }
            for (ECPointCompression c : VALUES) {
                if (value != c.getIndicatorValue()) continue;
                return c;
            }
            return null;
        }

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(ECPointCompression.class));
        }
    }
}

