/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import java.util.Objects;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import org.apache.sshd.common.util.security.SecurityUtils;

public class OpenSSHRSAPrivateKeyDecoder
extends AbstractPrivateKeyEntryDecoder<RSAPublicKey, RSAPrivateKey> {
    public static final BigInteger DEFAULT_PUBLIC_EXPONENT = KeyUtils.DEFAULT_RSA_PUBLIC_EXPONENT;
    public static final OpenSSHRSAPrivateKeyDecoder INSTANCE = new OpenSSHRSAPrivateKeyDecoder();

    public OpenSSHRSAPrivateKeyDecoder() {
        super(RSAPublicKey.class, RSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-rsa")));
    }

    @Override
    public RSAPrivateKey decodePrivateKey(SessionContext session, String keyType, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        if (!"ssh-rsa".equals(keyType)) {
            throw new InvalidKeySpecException("Unexpected key type: " + keyType);
        }
        BigInteger n = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger e = KeyEntryResolver.decodeBigInt(keyData);
        if (!Objects.equals(e, DEFAULT_PUBLIC_EXPONENT)) {
            this.log.warn("decodePrivateKey({}) non-standard RSA exponent found: {}", (Object)keyType, (Object)e);
        }
        BigInteger d = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger inverseQmodP = KeyEntryResolver.decodeBigInt(keyData);
        Objects.requireNonNull(inverseQmodP, "Missing iqmodp");
        BigInteger p = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger q = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger modulus = p.multiply(q);
        if (!Objects.equals(n, modulus)) {
            this.log.warn("decodePrivateKey({}) mismatched modulus values: encoded={}, calculated={}", keyType, n, modulus);
        }
        return (RSAPrivateKey)this.generatePrivateKey(new RSAPrivateCrtKeySpec(n, e, d, p, q, d.mod(p.subtract(BigInteger.ONE)), d.mod(q.subtract(BigInteger.ONE)), inverseQmodP));
    }

    @Override
    public String encodePrivateKey(SecureByteArrayOutputStream s2, RSAPrivateKey key, RSAPublicKey pubKey) throws IOException {
        Objects.requireNonNull(key, "No private key provided");
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey a = (RSAPrivateCrtKey)key;
            KeyEntryResolver.encodeBigInt(s2, a.getModulus());
            KeyEntryResolver.encodeBigInt(s2, a.getPublicExponent());
            KeyEntryResolver.encodeBigInt(s2, a.getPrivateExponent());
            KeyEntryResolver.encodeBigInt(s2, a.getCrtCoefficient());
            KeyEntryResolver.encodeBigInt(s2, a.getPrimeP());
            KeyEntryResolver.encodeBigInt(s2, a.getPrimeQ());
            return "ssh-rsa";
        }
        return null;
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    @Override
    public RSAPublicKey recoverPublicKey(RSAPrivateKey privateKey) throws GeneralSecurityException {
        return KeyUtils.recoverRSAPublicKey(privateKey);
    }

    @Override
    public RSAPublicKey clonePublicKey(RSAPublicKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        return (RSAPublicKey)this.generatePublicKey(new RSAPublicKeySpec(key.getModulus(), key.getPublicExponent()));
    }

    @Override
    public RSAPrivateKey clonePrivateKey(RSAPrivateKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        if (!(key instanceof RSAPrivateCrtKey)) {
            throw new InvalidKeyException("Cannot clone a non-RSAPrivateCrtKey: " + key.getClass().getSimpleName());
        }
        RSAPrivateCrtKey rsaPrv = (RSAPrivateCrtKey)key;
        return (RSAPrivateKey)this.generatePrivateKey(new RSAPrivateCrtKeySpec(rsaPrv.getModulus(), rsaPrv.getPublicExponent(), rsaPrv.getPrivateExponent(), rsaPrv.getPrimeP(), rsaPrv.getPrimeQ(), rsaPrv.getPrimeExponentP(), rsaPrv.getPrimeExponentQ(), rsaPrv.getCrtCoefficient()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("RSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("RSA");
    }
}

