/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.log.BaseLogEntry;
import org.openqa.selenium.bidi.log.ConsoleLogEntry;
import org.openqa.selenium.bidi.log.GenericLogEntry;
import org.openqa.selenium.bidi.log.JavascriptLogEntry;
import org.openqa.selenium.bidi.log.Log;
import org.openqa.selenium.bidi.log.LogEntry;
import org.openqa.selenium.internal.Require;

public class LogInspector
implements AutoCloseable {
    private final List<Consumer<ConsoleLogEntry>> consoleLogListeners = new LinkedList<Consumer<ConsoleLogEntry>>();
    private final List<Consumer<JavascriptLogEntry>> jsExceptionLogListeners = new LinkedList<Consumer<JavascriptLogEntry>>();
    private final List<Consumer<JavascriptLogEntry>> jsLogListeners = new LinkedList<Consumer<JavascriptLogEntry>>();
    private final List<Consumer<GenericLogEntry>> genericLogListeners = new LinkedList<Consumer<GenericLogEntry>>();
    private final Set<String> browsingContextIds;
    private final BiDi bidi;

    public LogInspector(WebDriver driver) {
        this(new HashSet<String>(), driver);
    }

    public LogInspector(String browsingContextId, WebDriver driver) {
        this(Collections.singleton(Require.nonNull("Browsing context id", browsingContextId)), driver);
    }

    public LogInspector(Set<String> browsingContextIds, WebDriver driver) {
        Require.nonNull("WebDriver", driver);
        Require.nonNull("Browsing context id list", browsingContextIds);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)((Object)driver)).getBiDi();
        this.browsingContextIds = browsingContextIds;
        this.initializeLogListener();
    }

    private void initializeLogListener() {
        Consumer<LogEntry> logEntryConsumer = logEntry -> {
            logEntry.getConsoleLogEntry().ifPresent(consoleLogEntry -> this.consoleLogListeners.forEach(consumer -> consumer.accept(consoleLogEntry)));
            logEntry.getJavascriptLogEntry().ifPresent(jsLogEntry -> {
                if (jsLogEntry.getLevel() == BaseLogEntry.LogLevel.ERROR) {
                    this.jsExceptionLogListeners.forEach(consumer -> consumer.accept(jsLogEntry));
                }
                this.jsLogListeners.forEach(consumer -> consumer.accept(jsLogEntry));
            });
            logEntry.getGenericLogEntry().ifPresent(genericLogEntry -> this.genericLogListeners.forEach(consumer -> consumer.accept(genericLogEntry)));
        };
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(Log.entryAdded(), logEntryConsumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, Log.entryAdded(), logEntryConsumer);
        }
    }

    public void onConsoleLog(Consumer<ConsoleLogEntry> consumer) {
        this.consoleLogListeners.add(consumer);
    }

    public void onJavaScriptLog(Consumer<JavascriptLogEntry> consumer) {
        this.jsLogListeners.add(consumer);
    }

    public void onJavaScriptException(Consumer<JavascriptLogEntry> consumer) {
        this.jsExceptionLogListeners.add(consumer);
    }

    public void onGenericLog(Consumer<GenericLogEntry> consumer) {
        this.genericLogListeners.add(consumer);
    }

    public void onLog(Consumer<LogEntry> consumer) {
        this.bidi.addListener(Log.entryAdded(), consumer);
    }

    @Override
    public void close() {
        this.bidi.clearListener(Log.entryAdded());
    }
}

