/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeDriverLogLevel;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.Browser;

public class ChromeOptions
extends ChromiumOptions<ChromeOptions> {
    public static final String CAPABILITY = "goog:chromeOptions";
    public static final String LOGGING_PREFS = "goog:loggingPrefs";
    private ChromeDriverLogLevel logLevel;

    public ChromeOptions() {
        super("browserName", Browser.CHROME.browserName(), CAPABILITY);
    }

    public ChromeOptions setLogLevel(ChromeDriverLogLevel logLevel) {
        this.logLevel = Require.nonNull("Log level", logLevel);
        return this;
    }

    @Override
    public ChromeOptions merge(Capabilities extraCapabilities) {
        Require.nonNull("Capabilities to merge", extraCapabilities);
        ChromeOptions newInstance = new ChromeOptions();
        newInstance.mergeInPlace(this);
        newInstance.mergeInPlace(extraCapabilities);
        newInstance.mergeInOptionsFromCaps(CAPABILITY, extraCapabilities);
        return newInstance;
    }

    public ChromeDriverLogLevel getLogLevel() {
        return this.logLevel;
    }
}

