/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.accessibility.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum AXValueSourceType {
    ATTRIBUTE("attribute"),
    IMPLICIT("implicit"),
    STYLE("style"),
    CONTENTS("contents"),
    PLACEHOLDER("placeholder"),
    RELATEDELEMENT("relatedElement");

    private String value;

    private AXValueSourceType(String value) {
        this.value = value;
    }

    public static AXValueSourceType fromString(String s2) {
        return Arrays.stream(AXValueSourceType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within AXValueSourceType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static AXValueSourceType fromJson(JsonInput input) {
        return AXValueSourceType.fromString(input.nextString());
    }
}

