/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.accessibility.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum AXValueType {
    BOOLEAN("boolean"),
    TRISTATE("tristate"),
    BOOLEANORUNDEFINED("booleanOrUndefined"),
    IDREF("idref"),
    IDREFLIST("idrefList"),
    INTEGER("integer"),
    NODE("node"),
    NODELIST("nodeList"),
    NUMBER("number"),
    STRING("string"),
    COMPUTEDSTRING("computedString"),
    TOKEN("token"),
    TOKENLIST("tokenList"),
    DOMRELATION("domRelation"),
    ROLE("role"),
    INTERNALROLE("internalRole"),
    VALUEUNDEFINED("valueUndefined");

    private String value;

    private AXValueType(String value) {
        this.value = value;
    }

    public static AXValueType fromString(String s2) {
        return Arrays.stream(AXValueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within AXValueType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static AXValueType fromJson(JsonInput input) {
        return AXValueType.fromString(input.nextString());
    }
}

