/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.audits.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v106.runtime.model.ScriptId;
import org.openqa.selenium.json.JsonInput;

public class SourceCodeLocation {
    private final Optional<ScriptId> scriptId;
    private final String url;
    private final Integer lineNumber;
    private final Integer columnNumber;

    public SourceCodeLocation(Optional<ScriptId> scriptId, String url, Integer lineNumber, Integer columnNumber) {
        this.scriptId = scriptId;
        this.url = Objects.requireNonNull(url, "url is required");
        this.lineNumber = Objects.requireNonNull(lineNumber, "lineNumber is required");
        this.columnNumber = Objects.requireNonNull(columnNumber, "columnNumber is required");
    }

    public Optional<ScriptId> getScriptId() {
        return this.scriptId;
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public Integer getColumnNumber() {
        return this.columnNumber;
    }

    private static SourceCodeLocation fromJson(JsonInput input) {
        Optional<ScriptId> scriptId = Optional.empty();
        String url = null;
        Integer lineNumber = 0;
        Integer columnNumber = 0;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "scriptId": {
                    scriptId = Optional.ofNullable((ScriptId)input.read((Type)((Object)ScriptId.class)));
                    continue block12;
                }
                case "url": {
                    url = input.nextString();
                    continue block12;
                }
                case "lineNumber": {
                    lineNumber = input.nextNumber().intValue();
                    continue block12;
                }
                case "columnNumber": {
                    columnNumber = input.nextNumber().intValue();
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SourceCodeLocation(scriptId, url, lineNumber, columnNumber);
    }
}

