/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.log.model;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v106.network.model.RequestId;
import org.openqa.selenium.devtools.v106.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v106.runtime.model.StackTrace;
import org.openqa.selenium.devtools.v106.runtime.model.Timestamp;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.reflect.TypeToken;

public class LogEntry {
    private final Source source;
    private final Level level;
    private final String text;
    private final Optional<Category> category;
    private final Timestamp timestamp;
    private final Optional<String> url;
    private final Optional<Integer> lineNumber;
    private final Optional<StackTrace> stackTrace;
    private final Optional<RequestId> networkRequestId;
    private final Optional<String> workerId;
    private final Optional<List<RemoteObject>> args;

    public LogEntry(Source source, Level level, String text, Optional<Category> category, Timestamp timestamp, Optional<String> url, Optional<Integer> lineNumber, Optional<StackTrace> stackTrace, Optional<RequestId> networkRequestId, Optional<String> workerId, Optional<List<RemoteObject>> args) {
        this.source = Objects.requireNonNull(source, "source is required");
        this.level = Objects.requireNonNull(level, "level is required");
        this.text = Objects.requireNonNull(text, "text is required");
        this.category = category;
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.url = url;
        this.lineNumber = lineNumber;
        this.stackTrace = stackTrace;
        this.networkRequestId = networkRequestId;
        this.workerId = workerId;
        this.args = args;
    }

    public Source getSource() {
        return this.source;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getText() {
        return this.text;
    }

    public Optional<Category> getCategory() {
        return this.category;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<Integer> getLineNumber() {
        return this.lineNumber;
    }

    public Optional<StackTrace> getStackTrace() {
        return this.stackTrace;
    }

    public Optional<RequestId> getNetworkRequestId() {
        return this.networkRequestId;
    }

    public Optional<String> getWorkerId() {
        return this.workerId;
    }

    public Optional<List<RemoteObject>> getArgs() {
        return this.args;
    }

    private static LogEntry fromJson(JsonInput input) {
        Source source = null;
        Level level = null;
        String text = null;
        Optional<Category> category = Optional.empty();
        Timestamp timestamp = null;
        Optional<String> url = Optional.empty();
        Optional<Integer> lineNumber = Optional.empty();
        Optional<StackTrace> stackTrace = Optional.empty();
        Optional<RequestId> networkRequestId = Optional.empty();
        Optional<String> workerId = Optional.empty();
        Optional<List<RemoteObject>> args = Optional.empty();
        input.beginObject();
        block26: while (input.hasNext()) {
            switch (input.nextName()) {
                case "source": {
                    source = Source.fromString(input.nextString());
                    continue block26;
                }
                case "level": {
                    level = Level.fromString(input.nextString());
                    continue block26;
                }
                case "text": {
                    text = input.nextString();
                    continue block26;
                }
                case "category": {
                    category = Optional.ofNullable(Category.fromString(input.nextString()));
                    continue block26;
                }
                case "timestamp": {
                    timestamp = (Timestamp)input.read((Type)((Object)Timestamp.class));
                    continue block26;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block26;
                }
                case "lineNumber": {
                    lineNumber = Optional.ofNullable(input.nextNumber().intValue());
                    continue block26;
                }
                case "stackTrace": {
                    stackTrace = Optional.ofNullable((StackTrace)input.read((Type)((Object)StackTrace.class)));
                    continue block26;
                }
                case "networkRequestId": {
                    networkRequestId = Optional.ofNullable((RequestId)input.read((Type)((Object)RequestId.class)));
                    continue block26;
                }
                case "workerId": {
                    workerId = Optional.ofNullable(input.nextString());
                    continue block26;
                }
                case "args": {
                    args = Optional.ofNullable((List)input.read(new TypeToken<List<RemoteObject>>(){}.getType()));
                    continue block26;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new LogEntry(source, level, text, category, timestamp, url, lineNumber, stackTrace, networkRequestId, workerId, args);
    }

    public static enum Category {
        CORS("cors");

        private String value;

        private Category(String value) {
            this.value = value;
        }

        public static Category fromString(String s2) {
            return Arrays.stream(Category.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Category "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Category fromJson(JsonInput input) {
            return Category.fromString(input.nextString());
        }
    }

    public static enum Level {
        VERBOSE("verbose"),
        INFO("info"),
        WARNING("warning"),
        ERROR("error");

        private String value;

        private Level(String value) {
            this.value = value;
        }

        public static Level fromString(String s2) {
            return Arrays.stream(Level.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Level "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Level fromJson(JsonInput input) {
            return Level.fromString(input.nextString());
        }
    }

    public static enum Source {
        XML("xml"),
        JAVASCRIPT("javascript"),
        NETWORK("network"),
        STORAGE("storage"),
        APPCACHE("appcache"),
        RENDERING("rendering"),
        SECURITY("security"),
        DEPRECATION("deprecation"),
        WORKER("worker"),
        VIOLATION("violation"),
        INTERVENTION("intervention"),
        RECOMMENDATION("recommendation"),
        OTHER("other");

        private String value;

        private Source(String value) {
            this.value = value;
        }

        public static Source fromString(String s2) {
            return Arrays.stream(Source.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Source "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Source fromJson(JsonInput input) {
            return Source.fromString(input.nextString());
        }
    }
}

