/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.memory;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v106.memory.model.PressureLevel;
import org.openqa.selenium.devtools.v106.memory.model.SamplingProfile;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.collect.ImmutableMap;

@Beta
public class Memory {
    public static Command<GetDOMCountersResponse> getDOMCounters() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<GetDOMCountersResponse>("Memory.getDOMCounters", params.build(), input -> (GetDOMCountersResponse)input.read((Type)((Object)GetDOMCountersResponse.class)));
    }

    public static Command<Void> prepareForLeakDetection() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Memory.prepareForLeakDetection", params.build());
    }

    public static Command<Void> forciblyPurgeJavaScriptMemory() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Memory.forciblyPurgeJavaScriptMemory", params.build());
    }

    public static Command<Void> setPressureNotificationsSuppressed(Boolean suppressed) {
        Objects.requireNonNull(suppressed, "suppressed is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("suppressed", suppressed);
        return new Command<Void>("Memory.setPressureNotificationsSuppressed", params.build());
    }

    public static Command<Void> simulatePressureNotification(PressureLevel level) {
        Objects.requireNonNull(level, "level is required");
        ImmutableMap.Builder<String, PressureLevel> params = ImmutableMap.builder();
        params.put("level", level);
        return new Command<Void>("Memory.simulatePressureNotification", params.build());
    }

    public static Command<Void> startSampling(Optional<Integer> samplingInterval, Optional<Boolean> suppressRandomness) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        samplingInterval.ifPresent(p -> params.put("samplingInterval", p));
        suppressRandomness.ifPresent(p -> params.put("suppressRandomness", p));
        return new Command<Void>("Memory.startSampling", params.build());
    }

    public static Command<Void> stopSampling() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Memory.stopSampling", params.build());
    }

    public static Command<SamplingProfile> getAllTimeSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingProfile>("Memory.getAllTimeSamplingProfile", params.build(), ConverterFunctions.map("profile", SamplingProfile.class));
    }

    public static Command<SamplingProfile> getBrowserSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingProfile>("Memory.getBrowserSamplingProfile", params.build(), ConverterFunctions.map("profile", SamplingProfile.class));
    }

    public static Command<SamplingProfile> getSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingProfile>("Memory.getSamplingProfile", params.build(), ConverterFunctions.map("profile", SamplingProfile.class));
    }

    public static class GetDOMCountersResponse {
        private final Integer documents;
        private final Integer nodes;
        private final Integer jsEventListeners;

        public GetDOMCountersResponse(Integer documents, Integer nodes, Integer jsEventListeners) {
            this.documents = Objects.requireNonNull(documents, "documents is required");
            this.nodes = Objects.requireNonNull(nodes, "nodes is required");
            this.jsEventListeners = Objects.requireNonNull(jsEventListeners, "jsEventListeners is required");
        }

        public Integer getDocuments() {
            return this.documents;
        }

        public Integer getNodes() {
            return this.nodes;
        }

        public Integer getJsEventListeners() {
            return this.jsEventListeners;
        }

        private static GetDOMCountersResponse fromJson(JsonInput input) {
            Integer documents = 0;
            Integer nodes = 0;
            Integer jsEventListeners = 0;
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "documents": {
                        documents = input.nextNumber().intValue();
                        continue block10;
                    }
                    case "nodes": {
                        nodes = input.nextNumber().intValue();
                        continue block10;
                    }
                    case "jsEventListeners": {
                        jsEventListeners = input.nextNumber().intValue();
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetDOMCountersResponse(documents, nodes, jsEventListeners);
        }
    }
}

