/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.network.model;

import java.util.Arrays;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

@Beta
public enum CookieBlockedReason {
    SECUREONLY("SecureOnly"),
    NOTONPATH("NotOnPath"),
    DOMAINMISMATCH("DomainMismatch"),
    SAMESITESTRICT("SameSiteStrict"),
    SAMESITELAX("SameSiteLax"),
    SAMESITEUNSPECIFIEDTREATEDASLAX("SameSiteUnspecifiedTreatedAsLax"),
    SAMESITENONEINSECURE("SameSiteNoneInsecure"),
    USERPREFERENCES("UserPreferences"),
    UNKNOWNERROR("UnknownError"),
    SCHEMEFULSAMESITESTRICT("SchemefulSameSiteStrict"),
    SCHEMEFULSAMESITELAX("SchemefulSameSiteLax"),
    SCHEMEFULSAMESITEUNSPECIFIEDTREATEDASLAX("SchemefulSameSiteUnspecifiedTreatedAsLax"),
    SAMEPARTYFROMCROSSPARTYCONTEXT("SamePartyFromCrossPartyContext"),
    NAMEVALUEPAIREXCEEDSMAXSIZE("NameValuePairExceedsMaxSize");

    private String value;

    private CookieBlockedReason(String value) {
        this.value = value;
    }

    public static CookieBlockedReason fromString(String s2) {
        return Arrays.stream(CookieBlockedReason.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within CookieBlockedReason "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static CookieBlockedReason fromJson(JsonInput input) {
        return CookieBlockedReason.fromString(input.nextString());
    }
}

