/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.page.model;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v106.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v106.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class FileChooserOpened {
    private final FrameId frameId;
    private final Mode mode;
    private final Optional<BackendNodeId> backendNodeId;

    public FileChooserOpened(FrameId frameId, Mode mode, Optional<BackendNodeId> backendNodeId) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.mode = Objects.requireNonNull(mode, "mode is required");
        this.backendNodeId = backendNodeId;
    }

    @Beta
    public FrameId getFrameId() {
        return this.frameId;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Beta
    public Optional<BackendNodeId> getBackendNodeId() {
        return this.backendNodeId;
    }

    private static FileChooserOpened fromJson(JsonInput input) {
        FrameId frameId = null;
        Mode mode = null;
        Optional<BackendNodeId> backendNodeId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block10;
                }
                case "mode": {
                    mode = Mode.fromString(input.nextString());
                    continue block10;
                }
                case "backendNodeId": {
                    backendNodeId = Optional.ofNullable((BackendNodeId)input.read((Type)((Object)BackendNodeId.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FileChooserOpened(frameId, mode, backendNodeId);
    }

    public static enum Mode {
        SELECTSINGLE("selectSingle"),
        SELECTMULTIPLE("selectMultiple");

        private String value;

        private Mode(String value) {
            this.value = value;
        }

        public static Mode fromString(String s2) {
            return Arrays.stream(Mode.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within Mode "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Mode fromJson(JsonInput input) {
            return Mode.fromString(input.nextString());
        }
    }
}

