/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.runtime.model;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v106.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v106.runtime.model.RemoteObject;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.reflect.TypeToken;

public class InspectRequested {
    private final RemoteObject object;
    private final Map<String, Object> hints;
    private final Optional<ExecutionContextId> executionContextId;

    public InspectRequested(RemoteObject object, Map<String, Object> hints, Optional<ExecutionContextId> executionContextId) {
        this.object = Objects.requireNonNull(object, "object is required");
        this.hints = Objects.requireNonNull(hints, "hints is required");
        this.executionContextId = executionContextId;
    }

    public RemoteObject getObject() {
        return this.object;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    @Beta
    public Optional<ExecutionContextId> getExecutionContextId() {
        return this.executionContextId;
    }

    private static InspectRequested fromJson(JsonInput input) {
        RemoteObject object = null;
        Map hints = null;
        Optional<ExecutionContextId> executionContextId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "object": {
                    object = (RemoteObject)input.read((Type)((Object)RemoteObject.class));
                    continue block10;
                }
                case "hints": {
                    hints = (Map)input.read(new TypeToken<Map<String, Object>>(){}.getType());
                    continue block10;
                }
                case "executionContextId": {
                    executionContextId = Optional.ofNullable((ExecutionContextId)input.read((Type)((Object)ExecutionContextId.class)));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InspectRequested(object, hints, executionContextId);
    }
}

