/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.webauthn.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v106.webauthn.model.AuthenticatorProtocol;
import org.openqa.selenium.devtools.v106.webauthn.model.AuthenticatorTransport;
import org.openqa.selenium.devtools.v106.webauthn.model.Ctap2Version;
import org.openqa.selenium.json.JsonInput;

public class VirtualAuthenticatorOptions {
    private final AuthenticatorProtocol protocol;
    private final Optional<Ctap2Version> ctap2Version;
    private final AuthenticatorTransport transport;
    private final Optional<Boolean> hasResidentKey;
    private final Optional<Boolean> hasUserVerification;
    private final Optional<Boolean> hasLargeBlob;
    private final Optional<Boolean> hasCredBlob;
    private final Optional<Boolean> hasMinPinLength;
    private final Optional<Boolean> automaticPresenceSimulation;
    private final Optional<Boolean> isUserVerified;

    public VirtualAuthenticatorOptions(AuthenticatorProtocol protocol, Optional<Ctap2Version> ctap2Version, AuthenticatorTransport transport, Optional<Boolean> hasResidentKey, Optional<Boolean> hasUserVerification, Optional<Boolean> hasLargeBlob, Optional<Boolean> hasCredBlob, Optional<Boolean> hasMinPinLength, Optional<Boolean> automaticPresenceSimulation, Optional<Boolean> isUserVerified) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is required");
        this.ctap2Version = ctap2Version;
        this.transport = Objects.requireNonNull(transport, "transport is required");
        this.hasResidentKey = hasResidentKey;
        this.hasUserVerification = hasUserVerification;
        this.hasLargeBlob = hasLargeBlob;
        this.hasCredBlob = hasCredBlob;
        this.hasMinPinLength = hasMinPinLength;
        this.automaticPresenceSimulation = automaticPresenceSimulation;
        this.isUserVerified = isUserVerified;
    }

    public AuthenticatorProtocol getProtocol() {
        return this.protocol;
    }

    public Optional<Ctap2Version> getCtap2Version() {
        return this.ctap2Version;
    }

    public AuthenticatorTransport getTransport() {
        return this.transport;
    }

    public Optional<Boolean> getHasResidentKey() {
        return this.hasResidentKey;
    }

    public Optional<Boolean> getHasUserVerification() {
        return this.hasUserVerification;
    }

    public Optional<Boolean> getHasLargeBlob() {
        return this.hasLargeBlob;
    }

    public Optional<Boolean> getHasCredBlob() {
        return this.hasCredBlob;
    }

    public Optional<Boolean> getHasMinPinLength() {
        return this.hasMinPinLength;
    }

    public Optional<Boolean> getAutomaticPresenceSimulation() {
        return this.automaticPresenceSimulation;
    }

    public Optional<Boolean> getIsUserVerified() {
        return this.isUserVerified;
    }

    private static VirtualAuthenticatorOptions fromJson(JsonInput input) {
        AuthenticatorProtocol protocol = null;
        Optional<Ctap2Version> ctap2Version = Optional.empty();
        AuthenticatorTransport transport = null;
        Optional<Boolean> hasResidentKey = Optional.empty();
        Optional<Boolean> hasUserVerification = Optional.empty();
        Optional<Boolean> hasLargeBlob = Optional.empty();
        Optional<Boolean> hasCredBlob = Optional.empty();
        Optional<Boolean> hasMinPinLength = Optional.empty();
        Optional<Boolean> automaticPresenceSimulation = Optional.empty();
        Optional<Boolean> isUserVerified = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "protocol": {
                    protocol = (AuthenticatorProtocol)((Object)input.read((Type)((Object)AuthenticatorProtocol.class)));
                    continue block24;
                }
                case "ctap2Version": {
                    ctap2Version = Optional.ofNullable((Ctap2Version)((Object)input.read((Type)((Object)Ctap2Version.class))));
                    continue block24;
                }
                case "transport": {
                    transport = (AuthenticatorTransport)((Object)input.read((Type)((Object)AuthenticatorTransport.class)));
                    continue block24;
                }
                case "hasResidentKey": {
                    hasResidentKey = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "hasUserVerification": {
                    hasUserVerification = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "hasLargeBlob": {
                    hasLargeBlob = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "hasCredBlob": {
                    hasCredBlob = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "hasMinPinLength": {
                    hasMinPinLength = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "automaticPresenceSimulation": {
                    automaticPresenceSimulation = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "isUserVerified": {
                    isUserVerified = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new VirtualAuthenticatorOptions(protocol, ctap2Version, transport, hasResidentKey, hasUserVerification, hasLargeBlob, hasCredBlob, hasMinPinLength, automaticPresenceSimulation, isUserVerified);
    }
}

