/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.network.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ResourcePriority {
    VERYLOW("VeryLow"),
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High"),
    VERYHIGH("VeryHigh");

    private String value;

    private ResourcePriority(String value) {
        this.value = value;
    }

    public static ResourcePriority fromString(String s2) {
        return Arrays.stream(ResourcePriority.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ResourcePriority "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ResourcePriority fromJson(JsonInput input) {
        return ResourcePriority.fromString(input.nextString());
    }
}

