/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.page.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v108.page.model.FrameId;
import org.openqa.selenium.devtools.v108.page.model.PrerenderFinalStatus;
import org.openqa.selenium.json.JsonInput;

@Beta
public class PrerenderAttemptCompleted {
    private final FrameId initiatingFrameId;
    private final String prerenderingUrl;
    private final PrerenderFinalStatus finalStatus;
    private final Optional<String> disallowedApiMethod;

    public PrerenderAttemptCompleted(FrameId initiatingFrameId, String prerenderingUrl, PrerenderFinalStatus finalStatus, Optional<String> disallowedApiMethod) {
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prerenderingUrl = Objects.requireNonNull(prerenderingUrl, "prerenderingUrl is required");
        this.finalStatus = Objects.requireNonNull(finalStatus, "finalStatus is required");
        this.disallowedApiMethod = disallowedApiMethod;
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrerenderingUrl() {
        return this.prerenderingUrl;
    }

    public PrerenderFinalStatus getFinalStatus() {
        return this.finalStatus;
    }

    public Optional<String> getDisallowedApiMethod() {
        return this.disallowedApiMethod;
    }

    private static PrerenderAttemptCompleted fromJson(JsonInput input) {
        FrameId initiatingFrameId = null;
        String prerenderingUrl = null;
        PrerenderFinalStatus finalStatus = null;
        Optional<String> disallowedApiMethod = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block12;
                }
                case "prerenderingUrl": {
                    prerenderingUrl = input.nextString();
                    continue block12;
                }
                case "finalStatus": {
                    finalStatus = (PrerenderFinalStatus)((Object)input.read((Type)((Object)PrerenderFinalStatus.class)));
                    continue block12;
                }
                case "disallowedApiMethod": {
                    disallowedApiMethod = Optional.ofNullable(input.nextString());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderAttemptCompleted(initiatingFrameId, prerenderingUrl, finalStatus, disallowedApiMethod);
    }
}

