/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint;

import java.util.Objects;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;

public abstract class AbstractTypeReference
implements TypeReference {
    private final String packageName;
    private final String simpleName;
    @Nullable
    private final TypeReference enclosingType;

    protected AbstractTypeReference(String packageName, String simpleName, @Nullable TypeReference enclosingType) {
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.enclosingType = enclosingType;
    }

    @Override
    public String getName() {
        TypeReference enclosingType = this.getEnclosingType();
        String simpleName = this.getSimpleName();
        return enclosingType != null ? enclosingType.getName() + "$" + simpleName : this.addPackageIfNecessary(simpleName);
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    @Nullable
    public TypeReference getEnclosingType() {
        return this.enclosingType;
    }

    protected abstract boolean isPrimitive();

    protected String addPackageIfNecessary(String part) {
        if (this.packageName.isEmpty() || this.packageName.equals("java.lang") && this.isPrimitive()) {
            return part;
        }
        return this.packageName + "." + part;
    }

    public int hashCode() {
        return Objects.hash(this.getCanonicalName());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypeReference)) {
            return false;
        }
        TypeReference otherReference = (TypeReference)other;
        return this.getCanonicalName().equals(otherReference.getCanonicalName());
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

