/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import ru.yandex.qatools.ashot.coordinates.Coords;

public class Screenshot
implements Serializable {
    private static final long serialVersionUID = 1241241256734156872L;
    private transient BufferedImage image;
    private Set<Coords> ignoredAreas = new HashSet<Coords>();
    private Set<Coords> coordsToCompare;
    private Coords originShift = new Coords(0, 0);

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public Screenshot(BufferedImage image) {
        this.image = image;
        this.coordsToCompare = new HashSet<Coords>(Arrays.asList(Coords.ofImage(image)));
    }

    public Set<Coords> getCoordsToCompare() {
        return this.coordsToCompare;
    }

    public void setCoordsToCompare(Set<Coords> coordsToCompare) {
        this.coordsToCompare = coordsToCompare;
    }

    public Set<Coords> getIgnoredAreas() {
        return this.ignoredAreas;
    }

    public void setIgnoredAreas(Set<Coords> ignoredAreas) {
        this.ignoredAreas = ignoredAreas;
    }

    public Coords getOriginShift() {
        return this.originShift;
    }

    public void setOriginShift(Coords originShift) {
        this.originShift = originShift;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ImageIO.write((RenderedImage)this.image, "png", out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.image = ImageIO.read(in);
    }
}

