/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.shooting.cutter;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import ru.yandex.qatools.ashot.shooting.InvalidViewportHeightException;
import ru.yandex.qatools.ashot.shooting.cutter.CutStrategy;

public class VariableCutStrategy
implements CutStrategy {
    public static final String SCRIPT = "var h = window.innerHeight || document.documentElement.clientHeight; return h;";
    private final int headerMin;
    private final int headerMax;
    private final int windowInnerHeightMin;
    private final int footerMax;
    private final int footerMin;

    public VariableCutStrategy(int headerMin, int headerMax, int footerMin, int footerMax, int windowInnerHeightMin) {
        this.headerMin = headerMin;
        this.headerMax = headerMax;
        this.footerMin = footerMin;
        this.footerMax = footerMax;
        this.windowInnerHeightMin = windowInnerHeightMin;
    }

    public VariableCutStrategy(int headerMin, int headerMax, int footerMax, int windowInnerHeightMin) {
        this(headerMin, headerMax, 0, footerMax, windowInnerHeightMin);
    }

    public VariableCutStrategy(int headerMin, int headerMax, int windowInnerHeightMin) {
        this(headerMin, headerMax, 0, windowInnerHeightMin);
    }

    @Override
    public int getHeaderHeight(WebDriver driver) {
        return this.getCutHeight((JavascriptExecutor)((Object)driver), this.headerMin, this.headerMax);
    }

    @Override
    public int getFooterHeight(WebDriver driver) {
        if (0 == this.footerMax && 0 == this.footerMin) {
            return 0;
        }
        return this.getCutHeight((JavascriptExecutor)((Object)driver), this.footerMin, this.footerMax);
    }

    private int getCutHeight(JavascriptExecutor driver, int heightMin, int heightMax) {
        int innerHeight = this.getWindowInnerHeight(driver);
        return innerHeight > this.windowInnerHeightMin ? heightMin : heightMax;
    }

    private int getWindowInnerHeight(JavascriptExecutor driver) {
        Number innerHeight;
        try {
            innerHeight = (Number)driver.executeScript(SCRIPT, new Object[0]);
        }
        catch (ClassCastException e) {
            throw new InvalidViewportHeightException("Could not acquire window.innerHeight property!", e);
        }
        if (innerHeight == null) {
            throw new InvalidViewportHeightException("Could not acquire window.innerHeight property! Returned value is null.");
        }
        return innerHeight.intValue();
    }
}

