/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.coordinates.Coords;

public final class ImageTool {
    private ImageTool() {
        throw new UnsupportedOperationException();
    }

    public static BufferedImage subImage(BufferedImage origin, Coords crop) {
        Coords intersection = Coords.ofImage(origin).intersection(crop);
        return origin.getSubimage(intersection.x, intersection.y, intersection.width, intersection.height);
    }

    public static Coords spreadCoordsInsideImage(Coords coordinates, int indent, BufferedImage image) {
        return new Coords(Math.max(0, coordinates.x - indent), Math.max(0, coordinates.y - indent), Math.min(image.getWidth(), coordinates.width + indent), Math.min(image.getHeight(), coordinates.height + indent));
    }

    public static boolean rgbCompare(int rgb1, int rgb2, int inaccuracy) {
        if (inaccuracy == 0) {
            return rgb1 == rgb2;
        }
        int red1 = (rgb1 & 0xFF0000) >> 16;
        int green1 = (rgb1 & 0xFF00) >> 8;
        int blue1 = rgb1 & 0xFF;
        int red2 = (rgb2 & 0xFF0000) >> 16;
        int green2 = (rgb2 & 0xFF00) >> 8;
        int blue2 = rgb2 & 0xFF;
        return Math.abs(red1 - red2) <= inaccuracy && Math.abs(green1 - green2) <= inaccuracy && Math.abs(blue1 - blue2) <= inaccuracy;
    }

    public static Matcher<BufferedImage> equalImage(final BufferedImage second) {
        return new TypeSafeMatcher<BufferedImage>(){

            @Override
            protected boolean matchesSafely(BufferedImage first) {
                if (!Coords.ofImage(first).equals(Coords.ofImage(second))) {
                    return false;
                }
                for (int x = 0; x < first.getWidth(); ++x) {
                    for (int y = 0; y < first.getHeight(); ++y) {
                        if (ImageTool.rgbCompare(first.getRGB(x, y), second.getRGB(x, y), 10)) continue;
                        return false;
                    }
                }
                return true;
            }

            @Override
            public void describeTo(Description description) {
            }
        };
    }

    public static byte[] toByteArray(Screenshot screenshot) throws IOException {
        return ImageTool.toByteArray(screenshot.getImage());
    }

    public static byte[] toByteArray(BufferedImage image) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(img, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }
}

