/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml.impl;

import io.ous.jtoml.ParseException;
import io.ous.jtoml.impl.StringCharacterIterator;
import io.ous.jtoml.impl.SymbolToken;
import io.ous.jtoml.impl.Token;
import io.ous.jtoml.impl.ValuedToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Tokenizer {
    private static final String BREAK_LINE = System.getProperty("line.separator");
    private static final String LITERAL_MULTILINE_STRING_DELIMITER = "'''";
    private static final char LITERAL_STRING_DELIMITER = '\'';
    private static final String MULTILINE_STRING_DELIMITER = "\"\"\"";
    private static final char BASIC_STRING_DELIMITER = '\"';
    private static final char COMMENT_START = '#';
    private final BufferedReader reader;
    private static final Pattern DATE_PATTERN = Pattern.compile("^(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2})(\\.(\\d{1,6}))?(Z|-\\d{2}:\\d{2})");
    private static final int DATE_PATTERN_GROUP_DATETIME = 1;
    private static final int DATE_PATTERN_GROUP_FRACTION = 3;
    private static final int DATE_PATTERN_GROUP_TZ = 4;
    private static final int DATE_FRACTION_PERCISION = 6;
    private static final int DATE_FRACTION_MAX = 1000000;
    private static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final Pattern FLOAT_PATTERN = Pattern.compile("^(\\+|-)?\\d+(_\\d+)*((\\.\\d+(_\\d+)*)|(?=E))(E(\\+|-)?\\d+(_\\d+)*)?", 2);
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^(\\+|-)?\\d+(_\\d+)*");
    private static final Pattern KEY_PATTERN = Pattern.compile("[A-Za-z0-9_-]+");
    private StringCharacterIterator chars;
    private boolean eof;
    private int currentLine;
    private ParsedToken current = null;
    private ParsedToken last = null;

    public static Tokenizer parse(Reader reader) throws IOException {
        return new Tokenizer(reader);
    }

    private static BufferedReader buffer(Reader reader) {
        return (BufferedReader)(reader instanceof BufferedReader ? reader : new BufferedReader(reader));
    }

    public Tokenizer(Reader reader) throws IOException {
        this.reader = Tokenizer.buffer(reader);
        this.currentLine = 0;
        this.eof = false;
        this.nextRawLine();
    }

    public ParsedToken peek() {
        this.last = this.current == null ? (this.current = this.next()) : this.current;
        return this.last;
    }

    public ParsedToken lastSeen() {
        return this.last;
    }

    public boolean hasNext() {
        return this.chars.hasNext() || !this.eof;
    }

    public ParsedToken next() {
        if (this.current == null) {
            int lineIndex = this.currentLine;
            int charIndex = this.chars.currentIndex();
            try {
                Token token = this.tryParseNext();
                if (token != null) {
                    this.last = new ParsedToken(token, lineIndex, charIndex);
                    return this.last;
                }
                this.last = this.next();
                return this.last;
            }
            catch (NoSuchElementException e) {
                throw this.error("Unexpected end of line", e);
            }
            catch (Exception e) {
                throw this.error("Unexpected Exception", e);
            }
        }
        ParsedToken ret = this.current;
        this.current = null;
        this.last = ret;
        return this.last;
    }

    protected boolean matches(SymbolToken symbol, ParsedToken ptoken) {
        return ptoken.token == symbol;
    }

    public boolean peekIfMatch(SymbolToken symbol) {
        return this.matches(symbol, this.peek());
    }

    public boolean nextIfMatch(SymbolToken symbol) {
        if (this.matches(symbol, this.peek())) {
            this.next();
            return true;
        }
        return false;
    }

    ParseException error(String s2) {
        return new ParseException(s2, this.currentLine, this.chars.currentIndex());
    }

    ParseException error(String s2, Exception e) {
        return new ParseException(s2, this.currentLine, this.chars.currentIndex(), e);
    }

    private void nextRawLine() throws IOException {
        if (this.eof) {
            throw this.error("Unexpected end of file");
        }
        ++this.currentLine;
        String line = this.reader.readLine();
        if (line == null) {
            this.eof = true;
            line = "";
        }
        this.chars = new StringCharacterIterator(line);
    }

    private char nextRawChar() throws IOException {
        if (!this.chars.hasNext()) {
            this.nextRawLine();
            return '\n';
        }
        return this.chars.next();
    }

    private Token parseMultilineString() throws IOException {
        StringBuilder builder = new StringBuilder();
        char c = this.nextRawChar();
        block4: while (true) {
            switch (c) {
                default: {
                    if (c == '\n') {
                        builder.append(BREAK_LINE);
                    } else {
                        builder.append(c);
                    }
                    c = this.nextRawChar();
                    continue block4;
                }
                case '\\': {
                    c = this.nextRawChar();
                    if (c == '\n') {
                        while (true) {
                            if (!Character.isWhitespace(c)) continue block4;
                            c = this.nextRawChar();
                        }
                    }
                    String unescaped = this.unescapeCharacter(c);
                    c = this.nextRawChar();
                    builder.append(unescaped);
                    continue block4;
                }
                case '\"': 
            }
            char c2 = this.nextRawChar();
            if (c2 == '\"') {
                char c3 = this.nextRawChar();
                if (c3 == '\"') {
                    return ValuedToken.multilineString(builder.toString());
                }
                builder.append(c);
                builder.append(c2);
                c = c3;
                continue;
            }
            builder.append(c);
            c = c2;
        }
    }

    private Token parseBasicString() {
        StringBuilder builder = new StringBuilder();
        block4: while (this.chars.hasNext()) {
            char c = this.chars.next();
            switch (c) {
                case '\\': {
                    char escaped = this.chars.next();
                    String unescaped = this.unescapeCharacter(escaped);
                    builder.append(unescaped);
                    continue block4;
                }
                default: {
                    builder.append(c);
                    continue block4;
                }
                case '\"': 
            }
            return ValuedToken.basicString(builder.toString());
        }
        throw new ParseException("No ending quote for basic string.", this.currentLine, this.chars.currentIndex());
    }

    private String unescapeCharacter(char escaped) {
        String unicode;
        switch (escaped) {
            case 'b': {
                return "\b";
            }
            case 't': {
                return "\t";
            }
            case 'n': {
                return "\n";
            }
            case 'f': {
                return "\f";
            }
            case 'r': {
                return "\r";
            }
            case '\"': {
                return "\"";
            }
            case '\\': {
                return "\\";
            }
            case 'u': {
                unicode = this.chars.next(4);
                break;
            }
            case 'U': {
                unicode = this.chars.next(4);
                break;
            }
            default: {
                throw this.error("Reserved escaped character '" + escaped + "'");
            }
        }
        try {
            int code = Integer.parseInt(unicode, 16);
            return new String(Character.toChars(code));
        }
        catch (NumberFormatException nfe) {
            throw this.error("Bad escape code " + unicode);
        }
    }

    private Token parseLiteralString() {
        StringBuilder builder = new StringBuilder();
        while (this.chars.hasNext()) {
            char c = this.chars.next();
            if (c == '\'') {
                return ValuedToken.literalString(builder.toString());
            }
            builder.append(c);
        }
        throw this.error("No ending single quote for literal string.");
    }

    private Token parseMultilineLiteralString() throws IOException {
        StringBuilder builder = new StringBuilder();
        while (!this.chars.nextIfSeqEquals(LITERAL_MULTILINE_STRING_DELIMITER)) {
            builder.append(this.nextRawChar());
        }
        return ValuedToken.literalString(builder.toString());
    }

    private Token parseDateToken(String group) {
        Matcher matcher = DATE_PATTERN.matcher(group);
        matcher.find();
        String datetimeStr = matcher.group(1);
        String tz = matcher.group(4);
        if (tz.equals("Z")) {
            tz = "+0000";
        }
        if (tz.indexOf(58) != -1) {
            tz = tz.replaceAll(":", "");
        }
        String fractionStr = matcher.group(3);
        SimpleDateFormat parser = new SimpleDateFormat(DATETIME_FORMAT);
        try {
            String fullDate = datetimeStr + tz;
            Date date = parser.parse(fullDate);
            if (fractionStr != null) {
                fractionStr = String.format("%-6s", fractionStr).replace(' ', '0');
                long fractional = Integer.parseInt(fractionStr);
                int millies = (int)(fractional * 1000L / 1000000L);
                date = new Date(date.getTime() + (long)millies);
            }
            return ValuedToken.dateToken(date);
        }
        catch (java.text.ParseException e) {
            throw this.error("Couldn't parse date " + group, e);
        }
    }

    private Token parseFloatToken(String group) {
        if (group.charAt(0) == '+') {
            group = group.substring(1);
        }
        group = group.replaceAll("_", "");
        return ValuedToken.floatToken(Double.valueOf(group));
    }

    private Token parseIntegerToken(String group) {
        if (group.charAt(0) == '+') {
            group = group.substring(1);
        }
        group = group.replaceAll("_", "");
        return ValuedToken.integerToken(Long.valueOf(group));
    }

    private Token tryParseNext() throws IOException {
        if (!this.chars.hasNext() || this.chars.nextIfEquals('#')) {
            if (this.hasNext()) {
                this.nextRawLine();
            }
            return SymbolToken.Newline;
        }
        if (Character.isWhitespace(this.chars.peek().charValue())) {
            this.chars.next();
            return null;
        }
        if (this.chars.nextIfSeqEquals(MULTILINE_STRING_DELIMITER)) {
            if (!this.chars.hasNext()) {
                this.nextRawLine();
            }
            return this.parseMultilineString();
        }
        if (this.chars.nextIfEquals('\"')) {
            return this.parseBasicString();
        }
        if (this.chars.nextIfSeqEquals(LITERAL_MULTILINE_STRING_DELIMITER)) {
            if (!this.chars.hasNext()) {
                this.nextRawLine();
            }
            return this.parseMultilineLiteralString();
        }
        if (this.chars.nextIfEquals('\'')) {
            return this.parseLiteralString();
        }
        if (this.chars.nextIfSeqEquals("true")) {
            return ValuedToken.booleanToken(true);
        }
        if (this.chars.nextIfSeqEquals("false")) {
            return ValuedToken.booleanToken(false);
        }
        String match = this.chars.nextIfMatches(DATE_PATTERN);
        if (match != null) {
            return this.parseDateToken(match);
        }
        match = this.chars.nextIfMatches(FLOAT_PATTERN);
        if (match != null) {
            return this.parseFloatToken(match);
        }
        match = this.chars.nextIfMatches(INTEGER_PATTERN);
        if (match != null) {
            return this.parseIntegerToken(match);
        }
        char peek = this.chars.peek().charValue();
        SymbolToken symbol = SymbolToken.getSymbolToken(peek);
        if (symbol != null) {
            this.chars.next();
            return symbol;
        }
        match = this.chars.nextIfMatches(KEY_PATTERN);
        if (match != null) {
            return ValuedToken.key(match);
        }
        throw this.error("Unexpected input: " + this.chars.peekAll());
    }

    static class ParsedToken {
        final Token token;
        final int line;
        final int chars;

        ParsedToken(Token token, int line, int chars) {
            this.token = token;
            this.line = line;
            this.chars = chars;
        }

        public String toString() {
            return (Object)((Object)this.token.getType()) + " at " + this.line + ":" + this.chars + " " + this.token;
        }
    }
}

