/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import java.util.Map;
import java.util.logging.Level;
import shaded.com.google.common.collect.ImmutableMap;

public enum ChromiumDriverLogLevel {
    ALL,
    INFO,
    DEBUG,
    WARNING,
    SEVERE,
    OFF;

    private static final Map<Level, ChromiumDriverLogLevel> logLevelToChromeLevelMap;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static ChromiumDriverLogLevel fromString(String text) {
        if (text != null) {
            for (ChromiumDriverLogLevel b : ChromiumDriverLogLevel.values()) {
                if (!text.equalsIgnoreCase(b.toString())) continue;
                return b;
            }
        }
        return null;
    }

    public static ChromiumDriverLogLevel fromLevel(Level level) {
        return logLevelToChromeLevelMap.getOrDefault(level, ALL);
    }

    static {
        logLevelToChromeLevelMap = new ImmutableMap.Builder<Level, ChromiumDriverLogLevel>().put(Level.ALL, ALL).put(Level.FINEST, DEBUG).put(Level.FINER, DEBUG).put(Level.FINE, DEBUG).put(Level.INFO, INFO).put(Level.WARNING, WARNING).put(Level.SEVERE, SEVERE).put(Level.OFF, OFF).build();
    }
}

