/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v107.cachestorage.model;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.devtools.v107.cachestorage.model.CachedResponseType;
import org.openqa.selenium.devtools.v107.cachestorage.model.Header;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.reflect.TypeToken;

public class DataEntry {
    private final String requestURL;
    private final String requestMethod;
    private final List<Header> requestHeaders;
    private final Number responseTime;
    private final Integer responseStatus;
    private final String responseStatusText;
    private final CachedResponseType responseType;
    private final List<Header> responseHeaders;

    public DataEntry(String requestURL, String requestMethod, List<Header> requestHeaders, Number responseTime, Integer responseStatus, String responseStatusText, CachedResponseType responseType, List<Header> responseHeaders) {
        this.requestURL = Objects.requireNonNull(requestURL, "requestURL is required");
        this.requestMethod = Objects.requireNonNull(requestMethod, "requestMethod is required");
        this.requestHeaders = Objects.requireNonNull(requestHeaders, "requestHeaders is required");
        this.responseTime = Objects.requireNonNull(responseTime, "responseTime is required");
        this.responseStatus = Objects.requireNonNull(responseStatus, "responseStatus is required");
        this.responseStatusText = Objects.requireNonNull(responseStatusText, "responseStatusText is required");
        this.responseType = Objects.requireNonNull(responseType, "responseType is required");
        this.responseHeaders = Objects.requireNonNull(responseHeaders, "responseHeaders is required");
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public List<Header> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Number getResponseTime() {
        return this.responseTime;
    }

    public Integer getResponseStatus() {
        return this.responseStatus;
    }

    public String getResponseStatusText() {
        return this.responseStatusText;
    }

    public CachedResponseType getResponseType() {
        return this.responseType;
    }

    public List<Header> getResponseHeaders() {
        return this.responseHeaders;
    }

    private static DataEntry fromJson(JsonInput input) {
        String requestURL = null;
        String requestMethod = null;
        List requestHeaders = null;
        Number responseTime = 0;
        Integer responseStatus = 0;
        String responseStatusText = null;
        CachedResponseType responseType = null;
        List responseHeaders = null;
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestURL": {
                    requestURL = input.nextString();
                    continue block20;
                }
                case "requestMethod": {
                    requestMethod = input.nextString();
                    continue block20;
                }
                case "requestHeaders": {
                    requestHeaders = (List)input.read(new TypeToken<List<Header>>(){}.getType());
                    continue block20;
                }
                case "responseTime": {
                    responseTime = input.nextNumber();
                    continue block20;
                }
                case "responseStatus": {
                    responseStatus = input.nextNumber().intValue();
                    continue block20;
                }
                case "responseStatusText": {
                    responseStatusText = input.nextString();
                    continue block20;
                }
                case "responseType": {
                    responseType = (CachedResponseType)((Object)input.read((Type)((Object)CachedResponseType.class)));
                    continue block20;
                }
                case "responseHeaders": {
                    responseHeaders = (List)input.read(new TypeToken<List<Header>>(){}.getType());
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DataEntry(requestURL, requestMethod, requestHeaders, responseTime, responseStatus, responseStatusText, responseType, responseHeaders);
    }
}

