/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v107.css;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v107.css.model.CSSComputedStyleProperty;
import org.openqa.selenium.devtools.v107.css.model.CSSContainerQuery;
import org.openqa.selenium.devtools.v107.css.model.CSSKeyframesRule;
import org.openqa.selenium.devtools.v107.css.model.CSSLayerData;
import org.openqa.selenium.devtools.v107.css.model.CSSMedia;
import org.openqa.selenium.devtools.v107.css.model.CSSRule;
import org.openqa.selenium.devtools.v107.css.model.CSSScope;
import org.openqa.selenium.devtools.v107.css.model.CSSStyle;
import org.openqa.selenium.devtools.v107.css.model.CSSStyleSheetHeader;
import org.openqa.selenium.devtools.v107.css.model.CSSSupports;
import org.openqa.selenium.devtools.v107.css.model.FontFace;
import org.openqa.selenium.devtools.v107.css.model.InheritedPseudoElementMatches;
import org.openqa.selenium.devtools.v107.css.model.InheritedStyleEntry;
import org.openqa.selenium.devtools.v107.css.model.PlatformFontUsage;
import org.openqa.selenium.devtools.v107.css.model.PseudoElementMatches;
import org.openqa.selenium.devtools.v107.css.model.RuleMatch;
import org.openqa.selenium.devtools.v107.css.model.RuleUsage;
import org.openqa.selenium.devtools.v107.css.model.SelectorList;
import org.openqa.selenium.devtools.v107.css.model.SourceRange;
import org.openqa.selenium.devtools.v107.css.model.StyleDeclarationEdit;
import org.openqa.selenium.devtools.v107.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v107.css.model.Value;
import org.openqa.selenium.devtools.v107.dom.model.NodeId;
import org.openqa.selenium.devtools.v107.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

@Beta
public class CSS {
    public static Command<CSSRule> addRule(StyleSheetId styleSheetId, String ruleText, SourceRange location) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(ruleText, "ruleText is required");
        Objects.requireNonNull(location, "location is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("ruleText", ruleText);
        params.put("location", location);
        return new Command<CSSRule>("CSS.addRule", params.build(), ConverterFunctions.map("rule", CSSRule.class));
    }

    public static Command<List<String>> collectClassNames(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        ImmutableMap.Builder<String, StyleSheetId> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        return new Command<List<String>>("CSS.collectClassNames", params.build(), ConverterFunctions.map("classNames", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<StyleSheetId> createStyleSheet(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder<String, FrameId> params = ImmutableMap.builder();
        params.put("frameId", frameId);
        return new Command<StyleSheetId>("CSS.createStyleSheet", params.build(), ConverterFunctions.map("styleSheetId", StyleSheetId.class));
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("CSS.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("CSS.enable", params.build());
    }

    public static Command<Void> forcePseudoState(NodeId nodeId, List<String> forcedPseudoClasses) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(forcedPseudoClasses, "forcedPseudoClasses is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("forcedPseudoClasses", forcedPseudoClasses);
        return new Command<Void>("CSS.forcePseudoState", params.build());
    }

    public static Command<GetBackgroundColorsResponse> getBackgroundColors(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<GetBackgroundColorsResponse>("CSS.getBackgroundColors", params.build(), input -> (GetBackgroundColorsResponse)input.read((Type)((Object)GetBackgroundColorsResponse.class)));
    }

    public static Command<List<CSSComputedStyleProperty>> getComputedStyleForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<List<CSSComputedStyleProperty>>("CSS.getComputedStyleForNode", params.build(), ConverterFunctions.map("computedStyle", new TypeToken<List<CSSComputedStyleProperty>>(){}.getType()));
    }

    public static Command<GetInlineStylesForNodeResponse> getInlineStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<GetInlineStylesForNodeResponse>("CSS.getInlineStylesForNode", params.build(), input -> (GetInlineStylesForNodeResponse)input.read((Type)((Object)GetInlineStylesForNodeResponse.class)));
    }

    public static Command<GetMatchedStylesForNodeResponse> getMatchedStylesForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<GetMatchedStylesForNodeResponse>("CSS.getMatchedStylesForNode", params.build(), input -> (GetMatchedStylesForNodeResponse)input.read((Type)((Object)GetMatchedStylesForNodeResponse.class)));
    }

    public static Command<List<CSSMedia>> getMediaQueries() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<CSSMedia>>("CSS.getMediaQueries", params.build(), ConverterFunctions.map("medias", new TypeToken<List<CSSMedia>>(){}.getType()));
    }

    public static Command<List<PlatformFontUsage>> getPlatformFontsForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<List<PlatformFontUsage>>("CSS.getPlatformFontsForNode", params.build(), ConverterFunctions.map("fonts", new TypeToken<List<PlatformFontUsage>>(){}.getType()));
    }

    public static Command<String> getStyleSheetText(StyleSheetId styleSheetId) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        ImmutableMap.Builder<String, StyleSheetId> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        return new Command<String>("CSS.getStyleSheetText", params.build(), ConverterFunctions.map("text", String.class));
    }

    @Beta
    public static Command<CSSLayerData> getLayersForNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<CSSLayerData>("CSS.getLayersForNode", params.build(), ConverterFunctions.map("rootLayer", CSSLayerData.class));
    }

    @Beta
    public static Command<Void> trackComputedStyleUpdates(List<CSSComputedStyleProperty> propertiesToTrack) {
        Objects.requireNonNull(propertiesToTrack, "propertiesToTrack is required");
        ImmutableMap.Builder<String, List<CSSComputedStyleProperty>> params = ImmutableMap.builder();
        params.put("propertiesToTrack", propertiesToTrack);
        return new Command<Void>("CSS.trackComputedStyleUpdates", params.build());
    }

    @Beta
    public static Command<List<NodeId>> takeComputedStyleUpdates() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<NodeId>>("CSS.takeComputedStyleUpdates", params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<Void> setEffectivePropertyValueForNode(NodeId nodeId, String propertyName, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(propertyName, "propertyName is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("propertyName", propertyName);
        params.put("value", value);
        return new Command<Void>("CSS.setEffectivePropertyValueForNode", params.build());
    }

    public static Command<Value> setKeyframeKey(StyleSheetId styleSheetId, SourceRange range, String keyText) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(keyText, "keyText is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("keyText", keyText);
        return new Command<Value>("CSS.setKeyframeKey", params.build(), ConverterFunctions.map("keyText", Value.class));
    }

    public static Command<CSSMedia> setMediaText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<CSSMedia>("CSS.setMediaText", params.build(), ConverterFunctions.map("media", CSSMedia.class));
    }

    @Beta
    public static Command<CSSContainerQuery> setContainerQueryText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<CSSContainerQuery>("CSS.setContainerQueryText", params.build(), ConverterFunctions.map("containerQuery", CSSContainerQuery.class));
    }

    @Beta
    public static Command<CSSSupports> setSupportsText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<CSSSupports>("CSS.setSupportsText", params.build(), ConverterFunctions.map("supports", CSSSupports.class));
    }

    @Beta
    public static Command<CSSScope> setScopeText(StyleSheetId styleSheetId, SourceRange range, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("text", text);
        return new Command<CSSScope>("CSS.setScopeText", params.build(), ConverterFunctions.map("scope", CSSScope.class));
    }

    public static Command<SelectorList> setRuleSelector(StyleSheetId styleSheetId, SourceRange range, String selector) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(range, "range is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("range", range);
        params.put("selector", selector);
        return new Command<SelectorList>("CSS.setRuleSelector", params.build(), ConverterFunctions.map("selectorList", SelectorList.class));
    }

    public static Command<String> setStyleSheetText(StyleSheetId styleSheetId, String text) {
        Objects.requireNonNull(styleSheetId, "styleSheetId is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("styleSheetId", styleSheetId);
        params.put("text", text);
        return new Command<String>("CSS.setStyleSheetText", params.build(), ConverterFunctions.map("sourceMapURL", String.class));
    }

    public static Command<List<CSSStyle>> setStyleTexts(List<StyleDeclarationEdit> edits) {
        Objects.requireNonNull(edits, "edits is required");
        ImmutableMap.Builder<String, List<StyleDeclarationEdit>> params = ImmutableMap.builder();
        params.put("edits", edits);
        return new Command<List<CSSStyle>>("CSS.setStyleTexts", params.build(), ConverterFunctions.map("styles", new TypeToken<List<CSSStyle>>(){}.getType()));
    }

    public static Command<Void> startRuleUsageTracking() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("CSS.startRuleUsageTracking", params.build());
    }

    public static Command<List<RuleUsage>> stopRuleUsageTracking() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<RuleUsage>>("CSS.stopRuleUsageTracking", params.build(), ConverterFunctions.map("ruleUsage", new TypeToken<List<RuleUsage>>(){}.getType()));
    }

    public static Command<TakeCoverageDeltaResponse> takeCoverageDelta() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<TakeCoverageDeltaResponse>("CSS.takeCoverageDelta", params.build(), input -> (TakeCoverageDeltaResponse)input.read((Type)((Object)TakeCoverageDeltaResponse.class)));
    }

    @Beta
    public static Command<Void> setLocalFontsEnabled(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enabled", enabled);
        return new Command<Void>("CSS.setLocalFontsEnabled", params.build());
    }

    public static Event<FontFace> fontsUpdated() {
        return new Event<FontFace>("CSS.fontsUpdated", ConverterFunctions.map("font", FontFace.class));
    }

    public static Event<Void> mediaQueryResultChanged() {
        return new Event<Void>("CSS.mediaQueryResultChanged", input -> null);
    }

    public static Event<CSSStyleSheetHeader> styleSheetAdded() {
        return new Event<CSSStyleSheetHeader>("CSS.styleSheetAdded", ConverterFunctions.map("header", CSSStyleSheetHeader.class));
    }

    public static Event<StyleSheetId> styleSheetChanged() {
        return new Event<StyleSheetId>("CSS.styleSheetChanged", ConverterFunctions.map("styleSheetId", StyleSheetId.class));
    }

    public static Event<StyleSheetId> styleSheetRemoved() {
        return new Event<StyleSheetId>("CSS.styleSheetRemoved", ConverterFunctions.map("styleSheetId", StyleSheetId.class));
    }

    public static class TakeCoverageDeltaResponse {
        private final List<RuleUsage> coverage;
        private final Number timestamp;

        public TakeCoverageDeltaResponse(List<RuleUsage> coverage, Number timestamp) {
            this.coverage = Objects.requireNonNull(coverage, "coverage is required");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        }

        public List<RuleUsage> getCoverage() {
            return this.coverage;
        }

        public Number getTimestamp() {
            return this.timestamp;
        }

        private static TakeCoverageDeltaResponse fromJson(JsonInput input) {
            List coverage = null;
            Number timestamp = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "coverage": {
                        coverage = (List)input.read(new TypeToken<List<RuleUsage>>(){}.getType());
                        continue block8;
                    }
                    case "timestamp": {
                        timestamp = input.nextNumber();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new TakeCoverageDeltaResponse(coverage, timestamp);
        }
    }

    public static class GetMatchedStylesForNodeResponse {
        private final Optional<CSSStyle> inlineStyle;
        private final Optional<CSSStyle> attributesStyle;
        private final Optional<List<RuleMatch>> matchedCSSRules;
        private final Optional<List<PseudoElementMatches>> pseudoElements;
        private final Optional<List<InheritedStyleEntry>> inherited;
        private final Optional<List<InheritedPseudoElementMatches>> inheritedPseudoElements;
        private final Optional<List<CSSKeyframesRule>> cssKeyframesRules;
        private final Optional<NodeId> parentLayoutNodeId;

        public GetMatchedStylesForNodeResponse(Optional<CSSStyle> inlineStyle, Optional<CSSStyle> attributesStyle, Optional<List<RuleMatch>> matchedCSSRules, Optional<List<PseudoElementMatches>> pseudoElements, Optional<List<InheritedStyleEntry>> inherited, Optional<List<InheritedPseudoElementMatches>> inheritedPseudoElements, Optional<List<CSSKeyframesRule>> cssKeyframesRules, Optional<NodeId> parentLayoutNodeId) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
            this.matchedCSSRules = matchedCSSRules;
            this.pseudoElements = pseudoElements;
            this.inherited = inherited;
            this.inheritedPseudoElements = inheritedPseudoElements;
            this.cssKeyframesRules = cssKeyframesRules;
            this.parentLayoutNodeId = parentLayoutNodeId;
        }

        public Optional<CSSStyle> getInlineStyle() {
            return this.inlineStyle;
        }

        public Optional<CSSStyle> getAttributesStyle() {
            return this.attributesStyle;
        }

        public Optional<List<RuleMatch>> getMatchedCSSRules() {
            return this.matchedCSSRules;
        }

        public Optional<List<PseudoElementMatches>> getPseudoElements() {
            return this.pseudoElements;
        }

        public Optional<List<InheritedStyleEntry>> getInherited() {
            return this.inherited;
        }

        public Optional<List<InheritedPseudoElementMatches>> getInheritedPseudoElements() {
            return this.inheritedPseudoElements;
        }

        public Optional<List<CSSKeyframesRule>> getCssKeyframesRules() {
            return this.cssKeyframesRules;
        }

        public Optional<NodeId> getParentLayoutNodeId() {
            return this.parentLayoutNodeId;
        }

        private static GetMatchedStylesForNodeResponse fromJson(JsonInput input) {
            Optional<CSSStyle> inlineStyle = Optional.empty();
            Optional<CSSStyle> attributesStyle = Optional.empty();
            Optional<List<RuleMatch>> matchedCSSRules = Optional.empty();
            Optional<List<PseudoElementMatches>> pseudoElements = Optional.empty();
            Optional<List<InheritedStyleEntry>> inherited = Optional.empty();
            Optional<List<InheritedPseudoElementMatches>> inheritedPseudoElements = Optional.empty();
            Optional<List<CSSKeyframesRule>> cssKeyframesRules = Optional.empty();
            Optional<NodeId> parentLayoutNodeId = Optional.empty();
            input.beginObject();
            block20: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = Optional.ofNullable((CSSStyle)input.read((Type)((Object)CSSStyle.class)));
                        continue block20;
                    }
                    case "attributesStyle": {
                        attributesStyle = Optional.ofNullable((CSSStyle)input.read((Type)((Object)CSSStyle.class)));
                        continue block20;
                    }
                    case "matchedCSSRules": {
                        matchedCSSRules = Optional.ofNullable((List)input.read(new TypeToken<List<RuleMatch>>(){}.getType()));
                        continue block20;
                    }
                    case "pseudoElements": {
                        pseudoElements = Optional.ofNullable((List)input.read(new TypeToken<List<PseudoElementMatches>>(){}.getType()));
                        continue block20;
                    }
                    case "inherited": {
                        inherited = Optional.ofNullable((List)input.read(new TypeToken<List<InheritedStyleEntry>>(){}.getType()));
                        continue block20;
                    }
                    case "inheritedPseudoElements": {
                        inheritedPseudoElements = Optional.ofNullable((List)input.read(new TypeToken<List<InheritedPseudoElementMatches>>(){}.getType()));
                        continue block20;
                    }
                    case "cssKeyframesRules": {
                        cssKeyframesRules = Optional.ofNullable((List)input.read(new TypeToken<List<CSSKeyframesRule>>(){}.getType()));
                        continue block20;
                    }
                    case "parentLayoutNodeId": {
                        parentLayoutNodeId = Optional.ofNullable((NodeId)input.read((Type)((Object)NodeId.class)));
                        continue block20;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetMatchedStylesForNodeResponse(inlineStyle, attributesStyle, matchedCSSRules, pseudoElements, inherited, inheritedPseudoElements, cssKeyframesRules, parentLayoutNodeId);
        }
    }

    public static class GetInlineStylesForNodeResponse {
        private final Optional<CSSStyle> inlineStyle;
        private final Optional<CSSStyle> attributesStyle;

        public GetInlineStylesForNodeResponse(Optional<CSSStyle> inlineStyle, Optional<CSSStyle> attributesStyle) {
            this.inlineStyle = inlineStyle;
            this.attributesStyle = attributesStyle;
        }

        public Optional<CSSStyle> getInlineStyle() {
            return this.inlineStyle;
        }

        public Optional<CSSStyle> getAttributesStyle() {
            return this.attributesStyle;
        }

        private static GetInlineStylesForNodeResponse fromJson(JsonInput input) {
            Optional<CSSStyle> inlineStyle = Optional.empty();
            Optional<CSSStyle> attributesStyle = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "inlineStyle": {
                        inlineStyle = Optional.ofNullable((CSSStyle)input.read((Type)((Object)CSSStyle.class)));
                        continue block8;
                    }
                    case "attributesStyle": {
                        attributesStyle = Optional.ofNullable((CSSStyle)input.read((Type)((Object)CSSStyle.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetInlineStylesForNodeResponse(inlineStyle, attributesStyle);
        }
    }

    public static class GetBackgroundColorsResponse {
        private final Optional<List<String>> backgroundColors;
        private final Optional<String> computedFontSize;
        private final Optional<String> computedFontWeight;

        public GetBackgroundColorsResponse(Optional<List<String>> backgroundColors, Optional<String> computedFontSize, Optional<String> computedFontWeight) {
            this.backgroundColors = backgroundColors;
            this.computedFontSize = computedFontSize;
            this.computedFontWeight = computedFontWeight;
        }

        public Optional<List<String>> getBackgroundColors() {
            return this.backgroundColors;
        }

        public Optional<String> getComputedFontSize() {
            return this.computedFontSize;
        }

        public Optional<String> getComputedFontWeight() {
            return this.computedFontWeight;
        }

        private static GetBackgroundColorsResponse fromJson(JsonInput input) {
            Optional<List<String>> backgroundColors = Optional.empty();
            Optional<String> computedFontSize = Optional.empty();
            Optional<String> computedFontWeight = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backgroundColors": {
                        backgroundColors = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                        continue block10;
                    }
                    case "computedFontSize": {
                        computedFontSize = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                    case "computedFontWeight": {
                        computedFontWeight = Optional.ofNullable(input.nextString());
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetBackgroundColorsResponse(backgroundColors, computedFontSize, computedFontWeight);
        }
    }
}

