/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v107.network.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v107.network.model.Initiator;
import org.openqa.selenium.devtools.v107.network.model.LoaderId;
import org.openqa.selenium.devtools.v107.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v107.network.model.Request;
import org.openqa.selenium.devtools.v107.network.model.RequestId;
import org.openqa.selenium.devtools.v107.network.model.ResourceType;
import org.openqa.selenium.devtools.v107.network.model.Response;
import org.openqa.selenium.devtools.v107.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v107.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class RequestWillBeSent {
    private final RequestId requestId;
    private final LoaderId loaderId;
    private final String documentURL;
    private final Request request;
    private final MonotonicTime timestamp;
    private final TimeSinceEpoch wallTime;
    private final Initiator initiator;
    private final Boolean redirectHasExtraInfo;
    private final Optional<Response> redirectResponse;
    private final Optional<ResourceType> type;
    private final Optional<FrameId> frameId;
    private final Optional<Boolean> hasUserGesture;

    public RequestWillBeSent(RequestId requestId, LoaderId loaderId, String documentURL, Request request, MonotonicTime timestamp, TimeSinceEpoch wallTime, Initiator initiator, Boolean redirectHasExtraInfo, Optional<Response> redirectResponse, Optional<ResourceType> type, Optional<FrameId> frameId, Optional<Boolean> hasUserGesture) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.loaderId = Objects.requireNonNull(loaderId, "loaderId is required");
        this.documentURL = Objects.requireNonNull(documentURL, "documentURL is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
        this.wallTime = Objects.requireNonNull(wallTime, "wallTime is required");
        this.initiator = Objects.requireNonNull(initiator, "initiator is required");
        this.redirectHasExtraInfo = Objects.requireNonNull(redirectHasExtraInfo, "redirectHasExtraInfo is required");
        this.redirectResponse = redirectResponse;
        this.type = type;
        this.frameId = frameId;
        this.hasUserGesture = hasUserGesture;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public LoaderId getLoaderId() {
        return this.loaderId;
    }

    public String getDocumentURL() {
        return this.documentURL;
    }

    public Request getRequest() {
        return this.request;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    public TimeSinceEpoch getWallTime() {
        return this.wallTime;
    }

    public Initiator getInitiator() {
        return this.initiator;
    }

    @Beta
    public Boolean getRedirectHasExtraInfo() {
        return this.redirectHasExtraInfo;
    }

    public Optional<Response> getRedirectResponse() {
        return this.redirectResponse;
    }

    public Optional<ResourceType> getType() {
        return this.type;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    public Optional<Boolean> getHasUserGesture() {
        return this.hasUserGesture;
    }

    private static RequestWillBeSent fromJson(JsonInput input) {
        RequestId requestId = null;
        LoaderId loaderId = null;
        String documentURL = null;
        Request request = null;
        MonotonicTime timestamp = null;
        TimeSinceEpoch wallTime = null;
        Initiator initiator = null;
        Boolean redirectHasExtraInfo = false;
        Optional<Response> redirectResponse = Optional.empty();
        Optional<ResourceType> type = Optional.empty();
        Optional<FrameId> frameId = Optional.empty();
        Optional<Boolean> hasUserGesture = Optional.empty();
        input.beginObject();
        block28: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read((Type)((Object)RequestId.class));
                    continue block28;
                }
                case "loaderId": {
                    loaderId = (LoaderId)input.read((Type)((Object)LoaderId.class));
                    continue block28;
                }
                case "documentURL": {
                    documentURL = input.nextString();
                    continue block28;
                }
                case "request": {
                    request = (Request)input.read((Type)((Object)Request.class));
                    continue block28;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read((Type)((Object)MonotonicTime.class));
                    continue block28;
                }
                case "wallTime": {
                    wallTime = (TimeSinceEpoch)input.read((Type)((Object)TimeSinceEpoch.class));
                    continue block28;
                }
                case "initiator": {
                    initiator = (Initiator)input.read((Type)((Object)Initiator.class));
                    continue block28;
                }
                case "redirectHasExtraInfo": {
                    redirectHasExtraInfo = input.nextBoolean();
                    continue block28;
                }
                case "redirectResponse": {
                    redirectResponse = Optional.ofNullable((Response)input.read((Type)((Object)Response.class)));
                    continue block28;
                }
                case "type": {
                    type = Optional.ofNullable((ResourceType)((Object)input.read((Type)((Object)ResourceType.class))));
                    continue block28;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read((Type)((Object)FrameId.class)));
                    continue block28;
                }
                case "hasUserGesture": {
                    hasUserGesture = Optional.ofNullable(input.nextBoolean());
                    continue block28;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RequestWillBeSent(requestId, loaderId, documentURL, request, timestamp, wallTime, initiator, redirectHasExtraInfo, redirectResponse, type, frameId, hasUserGesture);
    }
}

