/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum DeprecationIssueType {
    AUTHORIZATIONCOVEREDBYWILDCARD("AuthorizationCoveredByWildcard"),
    CANREQUESTURLHTTPCONTAININGNEWLINE("CanRequestURLHTTPContainingNewline"),
    CHROMELOADTIMESCONNECTIONINFO("ChromeLoadTimesConnectionInfo"),
    CHROMELOADTIMESFIRSTPAINTAFTERLOADTIME("ChromeLoadTimesFirstPaintAfterLoadTime"),
    CHROMELOADTIMESWASALTERNATEPROTOCOLAVAILABLE("ChromeLoadTimesWasAlternateProtocolAvailable"),
    COOKIEWITHTRUNCATINGCHAR("CookieWithTruncatingChar"),
    CROSSORIGINACCESSBASEDONDOCUMENTDOMAIN("CrossOriginAccessBasedOnDocumentDomain"),
    CROSSORIGINWINDOWALERT("CrossOriginWindowAlert"),
    CROSSORIGINWINDOWCONFIRM("CrossOriginWindowConfirm"),
    CSSSELECTORINTERNALMEDIACONTROLSOVERLAYCASTBUTTON("CSSSelectorInternalMediaControlsOverlayCastButton"),
    DEPRECATIONEXAMPLE("DeprecationExample"),
    DOCUMENTDOMAINSETTINGWITHOUTORIGINAGENTCLUSTERHEADER("DocumentDomainSettingWithoutOriginAgentClusterHeader"),
    EVENTPATH("EventPath"),
    EXPECTCTHEADER("ExpectCTHeader"),
    GEOLOCATIONINSECUREORIGIN("GeolocationInsecureOrigin"),
    GEOLOCATIONINSECUREORIGINDEPRECATEDNOTREMOVED("GeolocationInsecureOriginDeprecatedNotRemoved"),
    GETUSERMEDIAINSECUREORIGIN("GetUserMediaInsecureOrigin"),
    HOSTCANDIDATEATTRIBUTEGETTER("HostCandidateAttributeGetter"),
    IDENTITYINCANMAKEPAYMENTEVENT("IdentityInCanMakePaymentEvent"),
    INSECUREPRIVATENETWORKSUBRESOURCEREQUEST("InsecurePrivateNetworkSubresourceRequest"),
    LOCALCSSFILEEXTENSIONREJECTED("LocalCSSFileExtensionRejected"),
    MEDIASOURCEABORTREMOVE("MediaSourceAbortRemove"),
    MEDIASOURCEDURATIONTRUNCATINGBUFFERED("MediaSourceDurationTruncatingBuffered"),
    NOSYSEXWEBMIDIWITHOUTPERMISSION("NoSysexWebMIDIWithoutPermission"),
    NOTIFICATIONINSECUREORIGIN("NotificationInsecureOrigin"),
    NOTIFICATIONPERMISSIONREQUESTEDIFRAME("NotificationPermissionRequestedIframe"),
    OBSOLETEWEBRTCCIPHERSUITE("ObsoleteWebRtcCipherSuite"),
    OPENWEBDATABASEINSECURECONTEXT("OpenWebDatabaseInsecureContext"),
    OVERFLOWVISIBLEONREPLACEDELEMENT("OverflowVisibleOnReplacedElement"),
    PAYMENTINSTRUMENTS("PaymentInstruments"),
    PAYMENTREQUESTCSPVIOLATION("PaymentRequestCSPViolation"),
    PERSISTENTQUOTATYPE("PersistentQuotaType"),
    PICTURESOURCESRC("PictureSourceSrc"),
    PREFIXEDCANCELANIMATIONFRAME("PrefixedCancelAnimationFrame"),
    PREFIXEDREQUESTANIMATIONFRAME("PrefixedRequestAnimationFrame"),
    PREFIXEDSTORAGEINFO("PrefixedStorageInfo"),
    PREFIXEDVIDEODISPLAYINGFULLSCREEN("PrefixedVideoDisplayingFullscreen"),
    PREFIXEDVIDEOENTERFULLSCREEN("PrefixedVideoEnterFullscreen"),
    PREFIXEDVIDEOEXITFULLSCREEN("PrefixedVideoExitFullscreen"),
    PREFIXEDVIDEOSUPPORTSFULLSCREEN("PrefixedVideoSupportsFullscreen"),
    RANGEEXPAND("RangeExpand"),
    REQUESTEDSUBRESOURCEWITHEMBEDDEDCREDENTIALS("RequestedSubresourceWithEmbeddedCredentials"),
    RTCCONSTRAINTENABLEDTLSSRTPFALSE("RTCConstraintEnableDtlsSrtpFalse"),
    RTCCONSTRAINTENABLEDTLSSRTPTRUE("RTCConstraintEnableDtlsSrtpTrue"),
    RTCPEERCONNECTIONCOMPLEXPLANBSDPUSINGDEFAULTSDPSEMANTICS("RTCPeerConnectionComplexPlanBSdpUsingDefaultSdpSemantics"),
    RTCPEERCONNECTIONSDPSEMANTICSPLANB("RTCPeerConnectionSdpSemanticsPlanB"),
    RTCPMUXPOLICYNEGOTIATE("RtcpMuxPolicyNegotiate"),
    SHAREDARRAYBUFFERCONSTRUCTEDWITHOUTISOLATION("SharedArrayBufferConstructedWithoutIsolation"),
    TEXTTOSPEECH_DISALLOWEDBYAUTOPLAY("TextToSpeech_DisallowedByAutoplay"),
    V8SHAREDARRAYBUFFERCONSTRUCTEDINEXTENSIONWITHOUTISOLATION("V8SharedArrayBufferConstructedInExtensionWithoutIsolation"),
    XHRJSONENCODINGDETECTION("XHRJSONEncodingDetection"),
    XMLHTTPREQUESTSYNCHRONOUSINNONWORKEROUTSIDEBEFOREUNLOAD("XMLHttpRequestSynchronousInNonWorkerOutsideBeforeUnload"),
    XRSUPPORTSSESSION("XRSupportsSession");

    private String value;

    private DeprecationIssueType(String value) {
        this.value = value;
    }

    public static DeprecationIssueType fromString(String s2) {
        return Arrays.stream(DeprecationIssueType.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within DeprecationIssueType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static DeprecationIssueType fromJson(JsonInput input) {
        return DeprecationIssueType.fromString(input.nextString());
    }
}

