/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.audits.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum InspectorIssueCode {
    COOKIEISSUE("CookieIssue"),
    MIXEDCONTENTISSUE("MixedContentIssue"),
    BLOCKEDBYRESPONSEISSUE("BlockedByResponseIssue"),
    HEAVYADISSUE("HeavyAdIssue"),
    CONTENTSECURITYPOLICYISSUE("ContentSecurityPolicyIssue"),
    SHAREDARRAYBUFFERISSUE("SharedArrayBufferIssue"),
    TRUSTEDWEBACTIVITYISSUE("TrustedWebActivityIssue"),
    LOWTEXTCONTRASTISSUE("LowTextContrastIssue"),
    CORSISSUE("CorsIssue"),
    ATTRIBUTIONREPORTINGISSUE("AttributionReportingIssue"),
    QUIRKSMODEISSUE("QuirksModeIssue"),
    NAVIGATORUSERAGENTISSUE("NavigatorUserAgentIssue"),
    GENERICISSUE("GenericIssue"),
    DEPRECATIONISSUE("DeprecationIssue"),
    CLIENTHINTISSUE("ClientHintIssue"),
    FEDERATEDAUTHREQUESTISSUE("FederatedAuthRequestIssue");

    private String value;

    private InspectorIssueCode(String value) {
        this.value = value;
    }

    public static InspectorIssueCode fromString(String s2) {
        return Arrays.stream(InspectorIssueCode.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within InspectorIssueCode "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static InspectorIssueCode fromJson(JsonInput input) {
        return InspectorIssueCode.fromString(input.nextString());
    }
}

