/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.overlay.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ContrastAlgorithm {
    AA("aa"),
    AAA("aaa"),
    APCA("apca");

    private String value;

    private ContrastAlgorithm(String value) {
        this.value = value;
    }

    public static ContrastAlgorithm fromString(String s2) {
        return Arrays.stream(ContrastAlgorithm.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ContrastAlgorithm "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ContrastAlgorithm fromJson(JsonInput input) {
        return ContrastAlgorithm.fromString(input.nextString());
    }
}

