/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.backgroundservice;

import java.lang.reflect.Type;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v85.backgroundservice.model.BackgroundServiceEvent;
import org.openqa.selenium.devtools.v85.backgroundservice.model.RecordingStateChanged;
import org.openqa.selenium.devtools.v85.backgroundservice.model.ServiceName;
import shaded.com.google.common.collect.ImmutableMap;

@Beta
public class BackgroundService {
    public static Command<Void> startObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder<String, ServiceName> params = ImmutableMap.builder();
        params.put("service", service);
        return new Command<Void>("BackgroundService.startObserving", params.build());
    }

    public static Command<Void> stopObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder<String, ServiceName> params = ImmutableMap.builder();
        params.put("service", service);
        return new Command<Void>("BackgroundService.stopObserving", params.build());
    }

    public static Command<Void> setRecording(Boolean shouldRecord, ServiceName service) {
        Objects.requireNonNull(shouldRecord, "shouldRecord is required");
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("shouldRecord", shouldRecord);
        params.put("service", (Object)service);
        return new Command<Void>("BackgroundService.setRecording", params.build());
    }

    public static Command<Void> clearEvents(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder<String, ServiceName> params = ImmutableMap.builder();
        params.put("service", service);
        return new Command<Void>("BackgroundService.clearEvents", params.build());
    }

    public static Event<RecordingStateChanged> recordingStateChanged() {
        return new Event<RecordingStateChanged>("BackgroundService.recordingStateChanged", input -> (RecordingStateChanged)input.read((Type)((Object)RecordingStateChanged.class)));
    }

    public static Event<BackgroundServiceEvent> backgroundServiceEventReceived() {
        return new Event<BackgroundServiceEvent>("BackgroundService.backgroundServiceEventReceived", ConverterFunctions.map("backgroundServiceEvent", BackgroundServiceEvent.class));
    }
}

