/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Configs;
import org.openqa.selenium.grid.config.DescribedOption;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.json.Json;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.common.collect.ImmutableSortedSet;

public class ConfigFlags
implements HasRoles {
    private static final ImmutableSet<String> IGNORED_SECTIONS = ImmutableSet.of("java", "lc", "term");
    @Parameter(names={"--config"}, description="Config file to read from (may be specified more than once)")
    private List<Path> configFiles;
    @Parameter(names={"--dump-config"}, description="Dump the config of the server as JSON.", hidden=true)
    private boolean dumpConfig;
    @Parameter(names={"--config-help"}, description="Output detailed information about config options")
    private boolean dumpConfigHelp;

    @Override
    public Set<Role> getRoles() {
        return StandardGridRoles.ALL_ROLES;
    }

    public Config readConfigFiles() {
        if (this.configFiles == null || this.configFiles.isEmpty()) {
            return new MapConfig(ImmutableMap.of());
        }
        return new CompoundConfig((Config[])this.configFiles.stream().map(Configs::from).toArray(Config[]::new));
    }

    public boolean dumpConfig(Config config, PrintStream dumpTo) {
        if (!this.dumpConfig) {
            return false;
        }
        TreeMap toOutput = new TreeMap();
        for (String section : config.getSectionNames()) {
            if (section.isEmpty() || IGNORED_SECTIONS.contains(section)) continue;
            config.getOptions(section).forEach(option -> config.get(section, (String)option).ifPresent(value -> toOutput.computeIfAbsent(section, ignored -> new TreeMap()).put(option, value)));
        }
        dumpTo.print(new Json().toJson(toOutput));
        return true;
    }

    public boolean dumpConfigHelp(Config config, Set<Role> currentRoles, PrintStream dumpTo) {
        if (!this.dumpConfigHelp) {
            return false;
        }
        Map<String, Set> allOptions = DescribedOption.findAllMatchingOptions(currentRoles).stream().collect(Collectors.toMap(DescribedOption::section, ImmutableSortedSet::of, (l, r) -> ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.naturalOrder().addAll((Iterable)l)).addAll((Iterable)r)).build()));
        StringBuilder demoToml = new StringBuilder();
        demoToml.append("Configuration help for Toml config file").append("\n\n");
        demoToml.append("In case of parsing errors, validate the config using https://www.toml-lint.com/").append("\n\n");
        demoToml.append("Refer https://toml.io/en/ for TOML usage guidance").append("\n\n");
        allOptions.forEach((section, options) -> {
            demoToml.append("[").append((String)section).append("]\n");
            options.stream().filter(option -> !option.hidden).forEach(option -> {
                if (!option.optionName.isEmpty()) {
                    demoToml.append("# ").append(option.description).append("\n");
                }
                demoToml.append("# Type: ").append(option.type).append("\n");
                if (!option.defaultValue.isEmpty()) {
                    demoToml.append("# Default: ").append(option.defaultValue).append("\n");
                }
                Arrays.stream(option.example()).forEach(example -> {
                    demoToml.append("# Example: ").append("\n");
                    if (option.prefixed) {
                        demoToml.append("[[").append((String)section).append(".").append(option.optionName).append("]]").append(option.example(config, (String)example)).append("\n\n");
                    } else {
                        demoToml.append(option.optionName).append(" = ").append(option.example(config, (String)example)).append("\n\n");
                    }
                });
                demoToml.append("\n");
            });
        });
        dumpTo.print(demoToml);
        return true;
    }
}

