/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.collect.ImmutableSet;
import shaded.com.google.common.collect.ImmutableSortedSet;

public class MapConfig
implements Config {
    private final Map<String, Map<String, Object>> raw;

    public MapConfig(Map<String, Object> raw) {
        Require.nonNull("Underlying map", raw);
        ImmutableMap.Builder<String, ImmutableMap<String, Object>> builder = ImmutableMap.builder();
        for (Map.Entry<String, Object> entry : raw.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            ImmutableMap<String, Object> values = ((Map)entry.getValue()).entrySet().stream().filter(e -> e.getKey() instanceof String).collect(ImmutableMap.toImmutableMap(e -> String.valueOf(e.getKey()), Map.Entry::getValue));
            builder.put(entry.getKey(), values);
        }
        this.raw = builder.build();
    }

    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull("Section name", section);
        Require.nonNull("Option name", option);
        Map<String, Object> rawSection = this.raw.get(section);
        if (rawSection == null) {
            return Optional.empty();
        }
        Object value = rawSection.get(option);
        return value == null ? Optional.empty() : Optional.of(ImmutableList.of(String.valueOf(value)));
    }

    @Override
    public Set<String> getSectionNames() {
        return ImmutableSet.copyOf(this.raw.keySet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull("Section name to get options for", section);
        Map values = this.raw.getOrDefault(section, ImmutableMap.of());
        return ImmutableSortedSet.copyOf(values.keySet());
    }
}

