/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.util.Assert;

public class CronTrigger
implements Trigger {
    private final CronExpression expression;
    private final ZoneId zoneId;

    public CronTrigger(String expression) {
        this(expression, ZoneId.systemDefault());
    }

    public CronTrigger(String expression, TimeZone timeZone) {
        this(expression, timeZone.toZoneId());
    }

    public CronTrigger(String expression, ZoneId zoneId) {
        Assert.hasLength(expression, "Expression must not be empty");
        Assert.notNull((Object)zoneId, "ZoneId must not be null");
        this.expression = CronExpression.parse(expression);
        this.zoneId = zoneId;
    }

    public String getExpression() {
        return this.expression.toString();
    }

    @Override
    public Instant nextExecution(TriggerContext triggerContext) {
        Instant instant = triggerContext.lastCompletion();
        if (instant != null) {
            Instant scheduled = triggerContext.lastScheduledExecution();
            if (scheduled != null && instant.isBefore(scheduled)) {
                instant = scheduled;
            }
        } else {
            instant = triggerContext.getClock().instant();
        }
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(instant, this.zoneId);
        ZonedDateTime next = this.expression.next(dateTime);
        return next != null ? next.toInstant() : null;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof CronTrigger && this.expression.equals(((CronTrigger)other).expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public String toString() {
        return this.expression.toString();
    }
}

