/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.coordinates;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import ru.yandex.qatools.ashot.Screenshot;
import ru.yandex.qatools.ashot.coordinates.Coords;

public abstract class CoordsPreparationStrategy {
    public static CoordsPreparationStrategy simple() {
        return new CoordsPreparationStrategy(){

            @Override
            public Set<Coords> prepare(Collection<Coords> coordinates) {
                return new HashSet<Coords>(coordinates);
            }
        };
    }

    public static CoordsPreparationStrategy intersectingWith(final Screenshot screenshot) {
        return new CoordsPreparationStrategy(){

            @Override
            public Set<Coords> prepare(Collection<Coords> coordinates) {
                return Coords.intersection(screenshot.getCoordsToCompare(), Coords.setReferenceCoords(screenshot.getOriginShift(), new HashSet<Coords>(coordinates)));
            }
        };
    }

    public abstract Set<Coords> prepare(Collection<Coords> var1);
}

