/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.ashot.shooting;

import ru.yandex.qatools.ashot.shooting.CuttingDecorator;
import ru.yandex.qatools.ashot.shooting.RotatingDecorator;
import ru.yandex.qatools.ashot.shooting.ScalingDecorator;
import ru.yandex.qatools.ashot.shooting.ShootingStrategy;
import ru.yandex.qatools.ashot.shooting.SimpleShootingStrategy;
import ru.yandex.qatools.ashot.shooting.ViewportPastingDecorator;
import ru.yandex.qatools.ashot.shooting.cutter.CutStrategy;
import ru.yandex.qatools.ashot.shooting.cutter.FixedCutStrategy;
import ru.yandex.qatools.ashot.shooting.cutter.VariableCutStrategy;

public final class ShootingStrategies {
    private static final int SCROLL_TIMEOUT_IOS = 500;
    private static final int HEADER_IOS_7 = 98;
    private static final int HEADER_IOS_8_MIN = 41;
    private static final int HEADER_IOS_8_MAX = 65;
    private static final int VIEWPORT_MIN_IOS_8 = 960;
    private static final int VIEWPORT_MIN_IOS_8_SIM = 1250;
    private static final CutStrategy CUT_STRATEGY_IOS_7 = new FixedCutStrategy(98, 0);
    private static final CutStrategy CUT_STRATEGY_IOS_8 = ShootingStrategies.iOS8CutStrategy(960);
    private static final CutStrategy CUT_STRATEGY_IOS_8_SIM = ShootingStrategies.iOS8CutStrategy(1250);

    private ShootingStrategies() {
        throw new UnsupportedOperationException();
    }

    public static ShootingStrategy simple() {
        return new SimpleShootingStrategy();
    }

    public static ShootingStrategy scaling(ShootingStrategy shootingStrategy, float dpr) {
        return new ScalingDecorator(shootingStrategy).withDpr(dpr);
    }

    public static ShootingStrategy scaling(float dpr) {
        return ShootingStrategies.scaling(ShootingStrategies.simple(), dpr);
    }

    public static ShootingStrategy cutting(ShootingStrategy shootingStrategy, CutStrategy cutStrategy) {
        return new CuttingDecorator(shootingStrategy).withCutStrategy(cutStrategy);
    }

    public static ShootingStrategy cutting(CutStrategy cutStrategy) {
        return ShootingStrategies.cutting(ShootingStrategies.simple(), cutStrategy);
    }

    public static ShootingStrategy cutting(int headerToCut, int footerToCut) {
        return ShootingStrategies.cutting(new FixedCutStrategy(headerToCut, footerToCut));
    }

    public static ShootingStrategy viewportPasting(ShootingStrategy shootingStrategy, int scrollTimeout) {
        return new ViewportPastingDecorator(shootingStrategy).withScrollTimeout(scrollTimeout);
    }

    public static ShootingStrategy viewportPasting(int scrollTimeout) {
        return ShootingStrategies.viewportPasting(ShootingStrategies.simple(), scrollTimeout);
    }

    public static ShootingStrategy viewportNonRetina(ShootingStrategy shootingStrategy, int scrollTimeout, CutStrategy cutStrategy) {
        return ShootingStrategies.viewportPasting(ShootingStrategies.cutting(shootingStrategy, cutStrategy), scrollTimeout);
    }

    public static ShootingStrategy viewportNonRetina(int scrollTimeout, CutStrategy cutStrategy) {
        return ShootingStrategies.viewportPasting(ShootingStrategies.cutting(cutStrategy), scrollTimeout);
    }

    public static ShootingStrategy viewportNonRetina(int scrollTimeout, int headerToCut, int footerToCut) {
        return ShootingStrategies.viewportNonRetina(scrollTimeout, new FixedCutStrategy(headerToCut, footerToCut));
    }

    public static ShootingStrategy viewportRetina(ShootingStrategy shootingStrategy, int scrollTimeout, CutStrategy cutStrategy, float dpr) {
        ShootingStrategy scalingDecorator = ShootingStrategies.scaling(shootingStrategy, dpr);
        return ShootingStrategies.viewportNonRetina(scalingDecorator, scrollTimeout, cutStrategy);
    }

    public static ShootingStrategy viewportRetina(int scrollTimeout, CutStrategy cutStrategy, float dpr) {
        return ShootingStrategies.viewportRetina(ShootingStrategies.simple(), scrollTimeout, cutStrategy, dpr);
    }

    public static ShootingStrategy viewportRetina(int scrollTimeout, int headerToCut, int footerToCut, float dpr) {
        return ShootingStrategies.viewportRetina(scrollTimeout, new FixedCutStrategy(headerToCut, footerToCut), dpr);
    }

    public static ShootingStrategy viewportRetina(ShootingStrategy shootingStrategy, int scrollTimeout, int headerToCut, int footerToCut, float dpr) {
        return ShootingStrategies.viewportRetina(shootingStrategy, scrollTimeout, new FixedCutStrategy(headerToCut, footerToCut), dpr);
    }

    public static ShootingStrategy iPad2WithIOS7(ShootingStrategy shootingStrategy) {
        return ShootingStrategies.viewportIOSNonRetina(shootingStrategy, CUT_STRATEGY_IOS_7);
    }

    public static ShootingStrategy iPad2WithIOS7() {
        return ShootingStrategies.iPad2WithIOS7(ShootingStrategies.simple());
    }

    public static ShootingStrategy iPad2WithIOS8(ShootingStrategy shootingStrategy) {
        return ShootingStrategies.viewportIOSNonRetina(shootingStrategy, CUT_STRATEGY_IOS_8);
    }

    public static ShootingStrategy iPad2WithIOS8() {
        return ShootingStrategies.iPad2WithIOS8(ShootingStrategies.simple());
    }

    public static ShootingStrategy iPad2WithIOS8Simulator(ShootingStrategy shootingStrategy) {
        return ShootingStrategies.viewportIOSNonRetina(shootingStrategy, CUT_STRATEGY_IOS_8_SIM);
    }

    public static ShootingStrategy iPad2WithIOS8Simulator() {
        return ShootingStrategies.iPad2WithIOS8Simulator(ShootingStrategies.simple());
    }

    public static ShootingStrategy iPad2WithIOS8Retina(ShootingStrategy shootingStrategy) {
        return ShootingStrategies.viewportIOSRetina(shootingStrategy, CUT_STRATEGY_IOS_8);
    }

    public static ShootingStrategy iPad2WithIOS8Retina() {
        return ShootingStrategies.iPad2WithIOS8Retina(ShootingStrategies.simple());
    }

    public static ShootingStrategy iPad2WithIOS8RetinaSimulator(ShootingStrategy shootingStrategy) {
        return ShootingStrategies.viewportIOSRetina(shootingStrategy, CUT_STRATEGY_IOS_8_SIM);
    }

    public static ShootingStrategy iPad2WithIOS8RetinaSimulator() {
        return ShootingStrategies.iPad2WithIOS8RetinaSimulator(ShootingStrategies.simple());
    }

    public static ShootingStrategy iPadLandscapeOrientation(int scrollTimeout, CutStrategy cutStrategy) {
        return ShootingStrategies.viewportPasting(ShootingStrategies.iPadLandscapeOrientationSimple(cutStrategy), scrollTimeout);
    }

    public static ShootingStrategy iPadLandscapeOrientationSimple(CutStrategy cutStrategy) {
        return new RotatingDecorator(cutStrategy, ShootingStrategies.simple());
    }

    private static ShootingStrategy viewportIOSNonRetina(ShootingStrategy shootingStrategy, CutStrategy cutStrategy) {
        return ShootingStrategies.viewportNonRetina(shootingStrategy, 500, cutStrategy);
    }

    private static ShootingStrategy viewportIOSRetina(ShootingStrategy shootingStrategy, CutStrategy cutStrategy) {
        return ShootingStrategies.viewportRetina(shootingStrategy, 500, cutStrategy, 2.0f);
    }

    private static final CutStrategy iOS8CutStrategy(int minViewport) {
        return new VariableCutStrategy(41, 65, minViewport);
    }
}

