/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.google.auto.common;

import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import shaded.com.google.auto.common.MoreTypes;
import shaded.com.google.common.base.Preconditions;

public final class SimpleTypeAnnotationValue
implements AnnotationValue {
    private final TypeMirror value;

    private SimpleTypeAnnotationValue(TypeMirror value) {
        Preconditions.checkArgument(value.getKind().isPrimitive() || value.getKind().equals((Object)TypeKind.DECLARED) || value.getKind().equals((Object)TypeKind.ARRAY), "value must be a primitive, array, or declared type, but was %s (%s)", (Object)value.getKind(), (Object)value);
        if (value.getKind().equals((Object)TypeKind.DECLARED)) {
            Preconditions.checkArgument(MoreTypes.asDeclared(value).getTypeArguments().isEmpty(), "value must not be a parameterized type: %s", (Object)value);
        }
        this.value = value;
    }

    public static AnnotationValue of(TypeMirror value) {
        return new SimpleTypeAnnotationValue(value);
    }

    @Override
    public TypeMirror getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value + ".class";
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> visitor, P parameter) {
        return visitor.visitType(this.getValue(), parameter);
    }
}

