/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.webui.driver;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ndviet.library.configuration.ConfigurationManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.safari.SafariOptions;

public enum BrowserFactory {
    CHROME{

        @Override
        public WebDriver createLocalDriver() {
            return new ChromeDriver(this.getOptions());
        }

        public ChromeOptions getOptions() {
            ChromeOptions options = new ChromeOptions();
            List listArgs = ConfigurationManager.getInstance().getListValues("selenium.browser.chrome.args");
            options.addArguments(listArgs.toArray(new String[0]));
            LinkedHashMap listPrefs = ConfigurationManager.getInstance().getMapValues("selenium.browser.chrome.prefs");
            if (listPrefs != null) {
                listPrefs.forEach((key, value) -> options.setCapability(key.toString(), value));
            }
            return options;
        }
    }
    ,
    FIREFOX{

        @Override
        public WebDriver createLocalDriver() {
            return new FirefoxDriver(this.getOptions());
        }

        public FirefoxOptions getOptions() {
            FirefoxOptions options = new FirefoxOptions();
            List listArgs = ConfigurationManager.getInstance().getListValues("selenium.browser.firefox.args");
            options.addArguments(listArgs.toArray(new String[0]));
            LinkedHashMap listPrefs = ConfigurationManager.getInstance().getMapValues("selenium.browser.firefox.prefs");
            if (listPrefs != null) {
                listPrefs.forEach((key, value) -> options.setCapability(key.toString(), value));
            }
            return options;
        }
    }
    ,
    EDGE{

        @Override
        public WebDriver createLocalDriver() {
            return null;
        }

        public EdgeOptions getOptions() {
            return null;
        }
    }
    ,
    SAFARI{

        @Override
        public WebDriver createLocalDriver() {
            return null;
        }

        public SafariOptions getOptions() {
            return null;
        }
    };

    private static final Logger LOGGER;

    public abstract WebDriver createLocalDriver();

    public abstract AbstractDriverOptions<?> getOptions();

    static {
        LOGGER = LogManager.getLogger(BrowserFactory.class);
    }
}

