/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.webui.driver;

import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ndviet.library.configuration.ConfigurationManager;
import org.ndviet.library.webui.driver.BrowserFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.openqa.selenium.remote.RemoteWebDriver;

public class RemoteDriverFactory {
    private static final Logger LOGGER = LogManager.getLogger(RemoteDriverFactory.class);

    public static WebDriver createRemoteInstance(String browser) {
        AbstractDriverOptions<?> capability = BrowserFactory.valueOf(browser.toUpperCase()).getOptions();
        try {
            String hubUrl = ConfigurationManager.getInstance().getValue("selenium.hub.url");
            return new RemoteWebDriver(new URL(hubUrl), capability, RemoteDriverFactory.getEnableTracing());
        }
        catch (Exception e) {
            LOGGER.error("Could not open the browser.\n" + e.getMessage());
            return null;
        }
    }

    public static boolean getEnableTracing() {
        return Boolean.parseBoolean(ConfigurationManager.getInstance().getValue("selenium.enableTracing"));
    }
}

