/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.AsyncHttpClientState;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.ClientStats;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.channel.ChannelPool;
import org.asynchttpclient.cookie.CookieEvictionTask;
import org.asynchttpclient.cookie.CookieStore;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.handler.resumable.ResumableAsyncHandler;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.io.netty.channel.EventLoopGroup;
import shaded.io.netty.handler.codec.http.cookie.Cookie;
import shaded.io.netty.util.HashedWheelTimer;
import shaded.io.netty.util.Timer;
import shaded.io.netty.util.concurrent.DefaultThreadFactory;

public class DefaultAsyncHttpClient
implements AsyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAsyncHttpClient.class);
    private final AsyncHttpClientConfig config;
    private final boolean noRequestFilters;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;
    private final boolean allowStopNettyTimer;
    private final Timer nettyTimer;
    private SignatureCalculator signatureCalculator;

    public DefaultAsyncHttpClient() {
        this(new DefaultAsyncHttpClientConfig.Builder().build());
    }

    public DefaultAsyncHttpClient(AsyncHttpClientConfig config) {
        this.config = config;
        this.noRequestFilters = config.getRequestFilters().isEmpty();
        this.allowStopNettyTimer = config.getNettyTimer() == null;
        this.nettyTimer = this.allowStopNettyTimer ? this.newNettyTimer(config) : config.getNettyTimer();
        this.channelManager = new ChannelManager(config, this.nettyTimer);
        this.requestSender = new NettyRequestSender(config, this.channelManager, this.nettyTimer, new AsyncHttpClientState(this.closed));
        this.channelManager.configureBootstraps(this.requestSender);
        CookieStore cookieStore = config.getCookieStore();
        if (cookieStore != null) {
            int cookieStoreCount = config.getCookieStore().incrementAndGet();
            if (this.allowStopNettyTimer || cookieStoreCount == 1) {
                this.nettyTimer.newTimeout(new CookieEvictionTask(config.expiredCookieEvictionDelay(), cookieStore), config.expiredCookieEvictionDelay(), TimeUnit.MILLISECONDS);
            }
        }
    }

    private Timer newNettyTimer(AsyncHttpClientConfig config) {
        ThreadFactory threadFactory = config.getThreadFactory() != null ? config.getThreadFactory() : new DefaultThreadFactory(config.getThreadPoolName() + "-timer");
        HashedWheelTimer timer = new HashedWheelTimer(threadFactory, config.getHashedWheelTimerTickDuration(), TimeUnit.MILLISECONDS, config.getHashedWheelTimerSize());
        timer.start();
        return timer;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.channelManager.close();
            }
            catch (Throwable t) {
                LOGGER.warn("Unexpected error on ChannelManager close", t);
            }
            CookieStore cookieStore = this.config.getCookieStore();
            if (cookieStore != null) {
                cookieStore.decrementAndGet();
            }
            if (this.allowStopNettyTimer) {
                try {
                    this.nettyTimer.stop();
                }
                catch (Throwable t) {
                    LOGGER.warn("Unexpected error on HashedWheelTimer close", t);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public DefaultAsyncHttpClient setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
        return this;
    }

    @Override
    public BoundRequestBuilder prepare(String method, String url) {
        return this.requestBuilder(method, url);
    }

    @Override
    public BoundRequestBuilder prepareGet(String url) {
        return this.requestBuilder("GET", url);
    }

    @Override
    public BoundRequestBuilder prepareConnect(String url) {
        return this.requestBuilder("CONNECT", url);
    }

    @Override
    public BoundRequestBuilder prepareOptions(String url) {
        return this.requestBuilder("OPTIONS", url);
    }

    @Override
    public BoundRequestBuilder prepareHead(String url) {
        return this.requestBuilder("HEAD", url);
    }

    @Override
    public BoundRequestBuilder preparePost(String url) {
        return this.requestBuilder("POST", url);
    }

    @Override
    public BoundRequestBuilder preparePut(String url) {
        return this.requestBuilder("PUT", url);
    }

    @Override
    public BoundRequestBuilder prepareDelete(String url) {
        return this.requestBuilder("DELETE", url);
    }

    @Override
    public BoundRequestBuilder preparePatch(String url) {
        return this.requestBuilder("PATCH", url);
    }

    @Override
    public BoundRequestBuilder prepareTrace(String url) {
        return this.requestBuilder("TRACE", url);
    }

    @Override
    public BoundRequestBuilder prepareRequest(Request request) {
        return this.requestBuilder(request);
    }

    @Override
    public BoundRequestBuilder prepareRequest(RequestBuilder requestBuilder) {
        return this.prepareRequest(requestBuilder.build());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(Request request, AsyncHandler<T> handler) {
        if (this.config.getCookieStore() != null) {
            try {
                List<Cookie> cookies = this.config.getCookieStore().get(request.getUri());
                if (!cookies.isEmpty()) {
                    RequestBuilder requestBuilder = request.toBuilder();
                    for (Cookie cookie : cookies) {
                        requestBuilder.addOrReplaceCookie(cookie);
                    }
                    request = requestBuilder.build();
                }
            }
            catch (Exception e) {
                handler.onThrowable(e);
                return new ListenableFuture.CompletedFailure("Failed to set cookies of request", e);
            }
        }
        if (this.noRequestFilters) {
            return this.execute(request, handler);
        }
        FilterContext fc = new FilterContext.FilterContextBuilder<T>().asyncHandler(handler).request(request).build();
        try {
            fc = this.preProcessRequest(fc);
        }
        catch (Exception e) {
            handler.onThrowable(e);
            return new ListenableFuture.CompletedFailure("preProcessRequest failed", e);
        }
        return this.execute(fc.getRequest(), fc.getAsyncHandler());
    }

    @Override
    public <T> ListenableFuture<T> executeRequest(RequestBuilder requestBuilder, AsyncHandler<T> handler) {
        return this.executeRequest(requestBuilder.build(), handler);
    }

    @Override
    public ListenableFuture<Response> executeRequest(Request request) {
        return this.executeRequest(request, new AsyncCompletionHandlerBase());
    }

    @Override
    public ListenableFuture<Response> executeRequest(RequestBuilder requestBuilder) {
        return this.executeRequest(requestBuilder.build());
    }

    private <T> ListenableFuture<T> execute(Request request, AsyncHandler<T> asyncHandler) {
        try {
            return this.requestSender.sendRequest(request, asyncHandler, null);
        }
        catch (Exception e) {
            asyncHandler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
    }

    private <T> FilterContext<T> preProcessRequest(FilterContext<T> fc) throws FilterException {
        for (RequestFilter asyncFilter : this.config.getRequestFilters()) {
            fc = asyncFilter.filter(fc);
            Assertions.assertNotNull(fc, "filterContext");
        }
        Request request = fc.getRequest();
        if (fc.getAsyncHandler() instanceof ResumableAsyncHandler) {
            request = ((ResumableAsyncHandler)ResumableAsyncHandler.class.cast(fc.getAsyncHandler())).adjustRequestRange(request);
        }
        if (request.getRangeOffset() != 0L) {
            RequestBuilder builder = request.toBuilder();
            builder.setHeader((CharSequence)"Range", "bytes=" + request.getRangeOffset() + "-");
            request = builder.build();
        }
        fc = new FilterContext.FilterContextBuilder<T>(fc).request(request).build();
        return fc;
    }

    public ChannelPool getChannelPool() {
        return this.channelManager.getChannelPool();
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.channelManager.getEventLoopGroup();
    }

    @Override
    public ClientStats getClientStats() {
        return this.channelManager.getClientStats();
    }

    @Override
    public void flushChannelPoolPartitions(Predicate<Object> predicate) {
        this.getChannelPool().flushPartitions(predicate);
    }

    protected BoundRequestBuilder requestBuilder(String method, String url) {
        return (BoundRequestBuilder)((BoundRequestBuilder)new BoundRequestBuilder(this, method, this.config.isDisableUrlEncodingForBoundRequests()).setUrl(url)).setSignatureCalculator(this.signatureCalculator);
    }

    protected BoundRequestBuilder requestBuilder(Request prototype) {
        return (BoundRequestBuilder)new BoundRequestBuilder(this, prototype).setSignatureCalculator(this.signatureCalculator);
    }

    @Override
    public AsyncHttpClientConfig getConfig() {
        return this.config;
    }
}

