/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.spring;

import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringHelpers {
    private static volatile SpringHelpers m_instance;
    private final String m_applicationContextPath;
    private final AbstractApplicationContext m_applicationContext;

    public SpringHelpers(String appContextFilePath) {
        this.m_applicationContextPath = appContextFilePath;
        this.m_applicationContext = new ClassPathXmlApplicationContext(this.m_applicationContextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpringHelpers getInstance() {
        if (m_instance != null) return m_instance;
        Class<SpringHelpers> clazz = SpringHelpers.class;
        synchronized (SpringHelpers.class) {
            if (m_instance != null) return m_instance;
            String fileClassPathLocation = System.getProperty("applicationContextPath");
            m_instance = new SpringHelpers(fileClassPathLocation);
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    public <T> T getBeanOfType(Class<T> tClass) {
        return this.m_applicationContext.getBeansOfType(tClass).values().iterator().next();
    }

    public <T> T getBean(String beanId) {
        return (T)this.m_applicationContext.getBean(beanId);
    }
}

