/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v107.page.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v107.page.model.AdScriptId;
import org.openqa.selenium.devtools.v107.page.model.FrameId;
import org.openqa.selenium.devtools.v107.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;

public class FrameAttached {
    private final FrameId frameId;
    private final FrameId parentFrameId;
    private final Optional<StackTrace> stack;
    private final Optional<AdScriptId> adScriptId;

    public FrameAttached(FrameId frameId, FrameId parentFrameId, Optional<StackTrace> stack, Optional<AdScriptId> adScriptId) {
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.parentFrameId = Objects.requireNonNull(parentFrameId, "parentFrameId is required");
        this.stack = stack;
        this.adScriptId = adScriptId;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public FrameId getParentFrameId() {
        return this.parentFrameId;
    }

    public Optional<StackTrace> getStack() {
        return this.stack;
    }

    @Beta
    public Optional<AdScriptId> getAdScriptId() {
        return this.adScriptId;
    }

    private static FrameAttached fromJson(JsonInput input) {
        FrameId frameId = null;
        FrameId parentFrameId = null;
        Optional<StackTrace> stack = Optional.empty();
        Optional<AdScriptId> adScriptId = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "frameId": {
                    frameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block12;
                }
                case "parentFrameId": {
                    parentFrameId = (FrameId)input.read((Type)((Object)FrameId.class));
                    continue block12;
                }
                case "stack": {
                    stack = Optional.ofNullable((StackTrace)input.read((Type)((Object)StackTrace.class)));
                    continue block12;
                }
                case "adScriptId": {
                    adScriptId = Optional.ofNullable((AdScriptId)input.read((Type)((Object)AdScriptId.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new FrameAttached(frameId, parentFrameId, stack, adScriptId);
    }
}

