/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.util.Iterator;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import shaded.com.google.common.collect.ArrayListMultimap;
import shaded.com.google.common.collect.Multimap;

public class HttpRequest
extends HttpMessage<HttpRequest> {
    private final HttpMethod method;
    private final String uri;
    private final Multimap<String, String> queryParameters = ArrayListMultimap.create();

    public HttpRequest(HttpMethod method, String uri) {
        this.method = method;
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getQueryParameter(String name) {
        Iterable<String> allParams = this.getQueryParameters(name);
        if (allParams == null) {
            return null;
        }
        Iterator<String> iterator = allParams.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public HttpRequest addQueryParameter(String name, String value) {
        this.queryParameters.put(Require.nonNull("Name", name), Require.nonNull("Value", value));
        return this;
    }

    public Iterable<String> getQueryParameterNames() {
        return this.queryParameters.keySet();
    }

    public Iterable<String> getQueryParameters(String name) {
        return this.queryParameters.get(name);
    }

    public String toString() {
        return "(" + (Object)((Object)this.getMethod()) + ") " + this.getUri();
    }
}

