/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http.netty;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Response;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.RemoteCall;
import org.openqa.selenium.remote.http.netty.NettyMessages;

public class NettyHttpHandler
extends RemoteCall {
    private final HttpHandler handler;
    private final AsyncHttpClient client;

    public NettyHttpHandler(ClientConfig config, AsyncHttpClient client) {
        super(config);
        this.client = client;
        this.handler = config.filter().andFinally(this::makeCall);
    }

    @Override
    public HttpResponse execute(HttpRequest request) {
        return this.handler.execute(request);
    }

    private HttpResponse makeCall(HttpRequest request) {
        Require.nonNull("Request", request);
        ListenableFuture<Response> whenResponse = this.client.executeRequest(NettyMessages.toNettyRequest(this.getConfig(), request));
        try {
            Response response = (Response)whenResponse.get(this.getConfig().readTimeout().toMillis(), TimeUnit.MILLISECONDS);
            return NettyMessages.toSeleniumResponse(response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("NettyHttpHandler request interrupted", e);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof UncheckedIOException) {
                throw (UncheckedIOException)cause;
            }
            if (cause instanceof IOException) {
                throw new UncheckedIOException((IOException)cause);
            }
            throw new RuntimeException("NettyHttpHandler request execution error", e);
        }
    }
}

