/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.locators;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.support.locators.RelativeLocatorScript;
import shaded.com.google.common.collect.ImmutableList;
import shaded.com.google.common.collect.ImmutableMap;

public class RelativeLocator {
    private static final Json JSON = new Json();
    private static final int CLOSE_IN_PIXELS = 100;

    public static RelativeBy with(By by) {
        Require.nonNull("By to look for", by);
        return new RelativeBy((Object)by);
    }

    private static Object asAtomLocatorParameter(Object object) {
        if (object instanceof WebElement) {
            return object;
        }
        if (!(object instanceof By)) {
            throw new IllegalArgumentException("Expected locator to be either an element or a By: " + object);
        }
        RelativeLocator.assertLocatorCanBeSerialized(object);
        Map raw = (Map)JSON.toType(JSON.toJson(object), Json.MAP_TYPE);
        if (!(raw.get("using") instanceof String)) {
            throw new JsonException("Expected JSON encoded form of locator to have a 'using' field. " + raw);
        }
        if (!raw.containsKey("value")) {
            throw new JsonException("Expected JSON encoded form of locator to have a 'value' field: " + raw);
        }
        return ImmutableMap.of((String)raw.get("using"), raw.get("value"));
    }

    private static void assertLocatorCanBeSerialized(Object locator) {
        Require.nonNull("Locator", locator);
        Class<?> clazz = locator.getClass();
        while (!clazz.equals(Object.class)) {
            try {
                clazz.getDeclaredMethod("toJson", new Class[0]);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException("Locator must be serializable to JSON using a `toJson` method. " + locator);
    }

    public static class RelativeBy
    extends By
    implements By.Remotable {
        private final Object root;
        private final List<Map<String, Object>> filters;

        private RelativeBy(Object rootLocator) {
            this(rootLocator, ImmutableList.of());
        }

        private RelativeBy(Object rootLocator, List<Map<String, Object>> filters) {
            if (rootLocator instanceof By) {
                RelativeLocator.assertLocatorCanBeSerialized(rootLocator);
                rootLocator = RelativeLocator.asAtomLocatorParameter(rootLocator);
            } else if (rootLocator instanceof Map) {
                if (((Map)rootLocator).keySet().size() != 1) {
                    throw new IllegalArgumentException("Root locators as find element payload must only have a single key: " + rootLocator);
                }
            } else if (!(rootLocator instanceof WebElement)) {
                throw new IllegalArgumentException("Root locator must be an element or a locator: " + rootLocator);
            }
            this.root = Require.nonNull("Root locator", rootLocator);
            this.filters = ImmutableList.copyOf((Collection)Require.nonNull("Filters", filters));
        }

        public RelativeBy above(WebElement element) {
            Require.nonNull("Element to search above of", element);
            return this.simpleDirection("above", element);
        }

        public RelativeBy above(By locator) {
            Require.nonNull("Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("above", locator);
        }

        public RelativeBy below(WebElement element) {
            Require.nonNull("Element to search below of", element);
            return this.simpleDirection("below", element);
        }

        public RelativeBy below(By locator) {
            Require.nonNull("Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("below", locator);
        }

        public RelativeBy toLeftOf(WebElement element) {
            Require.nonNull("Element to search to left of", element);
            return this.simpleDirection("left", element);
        }

        public RelativeBy toLeftOf(By locator) {
            Require.nonNull("Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("left", locator);
        }

        public RelativeBy toRightOf(WebElement element) {
            Require.nonNull("Element to search to right of", element);
            return this.simpleDirection("right", element);
        }

        public RelativeBy toRightOf(By locator) {
            Require.nonNull("Locator", locator);
            RelativeLocator.assertLocatorCanBeSerialized(locator);
            return this.simpleDirection("right", locator);
        }

        public RelativeBy near(WebElement element) {
            Require.nonNull("Element to search near", element);
            return this.near(element, 100);
        }

        public RelativeBy near(WebElement element, int atMostDistanceInPixels) {
            Require.nonNull("Element to search near", element);
            Require.positive("Distance", atMostDistanceInPixels);
            return this.near((Object)element, atMostDistanceInPixels);
        }

        public RelativeBy near(By locator) {
            Require.nonNull("Locator", locator);
            return this.near((Object)locator, 100);
        }

        public RelativeBy near(By locator, int atMostDistanceInPixels) {
            Require.nonNull("Locator", locator);
            Require.positive("Distance", atMostDistanceInPixels);
            return this.near((Object)locator, atMostDistanceInPixels);
        }

        private RelativeBy near(Object locator, int atMostDistanceInPixels) {
            Require.nonNull("Locator", locator);
            Require.positive("Distance", atMostDistanceInPixels);
            return new RelativeBy(this.root, this.amend(ImmutableMap.of("kind", "near", "args", ImmutableList.of(RelativeLocator.asAtomLocatorParameter(locator), Integer.valueOf(atMostDistanceInPixels)))));
        }

        @Override
        public List<WebElement> findElements(SearchContext context) {
            JavascriptExecutor js = this.getJavascriptExecutor(context);
            List elements = (List)js.executeScript(RelativeLocatorScript.FIND_ELEMENTS, RelativeLocator.asAtomLocatorParameter(this));
            return elements;
        }

        private RelativeBy simpleDirection(String direction, Object locator) {
            Require.nonNull("Direction to search in", direction);
            Require.nonNull("Locator", locator);
            return new RelativeBy(this.root, this.amend(ImmutableMap.of("kind", direction, "args", ImmutableList.of(RelativeLocator.asAtomLocatorParameter(locator)))));
        }

        private List<Map<String, Object>> amend(Map<String, Object> toAdd) {
            return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.filters)).add(toAdd)).build();
        }

        @Override
        public By.Remotable.Parameters getRemoteParameters() {
            return new By.Remotable.Parameters("relative", ImmutableMap.of("root", this.root, "filters", this.filters));
        }

        private Map<String, Object> toJson() {
            return ImmutableMap.of("using", "relative", "value", ImmutableMap.of("root", this.root, "filters", this.filters));
        }
    }
}

