/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.internal.ValidationUtil;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkObservableInstrument;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.CallbackRegistration;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.SdkObservableMeasurement;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Consumer;

abstract class AbstractInstrumentBuilder<BuilderT extends AbstractInstrumentBuilder<?>> {
    static final String DEFAULT_UNIT = "";
    private final MeterProviderSharedState meterProviderSharedState;
    private final InstrumentType type;
    private final InstrumentValueType valueType;
    private String description;
    private String unit;
    protected final MeterSharedState meterSharedState;
    protected final String instrumentName;

    AbstractInstrumentBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, InstrumentType type, InstrumentValueType valueType, String name, String description, String unit) {
        this.type = type;
        this.valueType = valueType;
        this.instrumentName = name;
        this.description = description;
        this.unit = unit;
        this.meterProviderSharedState = meterProviderSharedState;
        this.meterSharedState = meterSharedState;
    }

    protected abstract BuilderT getThis();

    public BuilderT setUnit(String unit) {
        this.unit = !ValidationUtil.checkValidInstrumentUnit(unit, " Using \"\" for instrument " + this.instrumentName + " instead.") ? DEFAULT_UNIT : unit;
        return this.getThis();
    }

    public BuilderT setDescription(String description) {
        this.description = description;
        return this.getThis();
    }

    protected <T> T swapBuilder(SwapBuilder<T> swapper) {
        return swapper.newBuilder(this.meterProviderSharedState, this.meterSharedState, this.instrumentName, this.description, this.unit);
    }

    final <I extends AbstractInstrument> I buildSynchronousInstrument(BiFunction<InstrumentDescriptor, WriteableMetricStorage, I> instrumentFactory) {
        InstrumentDescriptor descriptor = InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, this.type, this.valueType);
        WriteableMetricStorage storage = this.meterSharedState.registerSynchronousMetricStorage(descriptor, this.meterProviderSharedState);
        return (I)((AbstractInstrument)instrumentFactory.apply(descriptor, storage));
    }

    final SdkObservableInstrument registerDoubleAsynchronousInstrument(InstrumentType type, Consumer<ObservableDoubleMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    final SdkObservableInstrument registerLongAsynchronousInstrument(InstrumentType type, Consumer<ObservableLongMeasurement> updater) {
        SdkObservableMeasurement sdkObservableMeasurement = this.buildObservableMeasurement(type);
        Runnable runnable = () -> updater.accept(sdkObservableMeasurement);
        CallbackRegistration callbackRegistration = CallbackRegistration.create(Collections.singletonList(sdkObservableMeasurement), runnable);
        this.meterSharedState.registerCallback(callbackRegistration);
        return new SdkObservableInstrument(this.meterSharedState, callbackRegistration);
    }

    final SdkObservableMeasurement buildObservableMeasurement(InstrumentType type) {
        InstrumentDescriptor descriptor = InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, type, this.valueType);
        return this.meterSharedState.registerObservableMeasurement(descriptor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{descriptor=" + InstrumentDescriptor.create(this.instrumentName, this.description, this.unit, this.type, this.valueType) + "}";
    }

    @FunctionalInterface
    protected static interface SwapBuilder<T> {
        public T newBuilder(MeterProviderSharedState var1, MeterSharedState var2, String var3, String var4, String var5);
    }
}

