/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library;

import java.util.ArrayList;
import org.ndviet.library.Browser;
import org.ndviet.library.configuration.ConfigurationFactory;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class BrowserManagement {
    private static WebDriver m_driver = null;
    private static BrowserManagement m_instance = null;
    private static String m_browser = null;

    BrowserManagement() {
        m_browser = ConfigurationFactory.getInstance().getValue("selenium.browser.type");
    }

    public static BrowserManagement getInstance() {
        if (m_instance == null) {
            m_instance = new BrowserManagement();
        }
        return m_instance;
    }

    public WebDriver getDriver() {
        return m_driver;
    }

    public void openBrowser() {
        m_driver = Browser.Type.FIREFOX.getName().equalsIgnoreCase(m_browser) ? Browser.Type.FIREFOX.openBrowser() : Browser.Type.CHROME.openBrowser();
        m_driver.manage().window().maximize();
    }

    public void openBrowser(String url) {
        this.openBrowser();
        this.goToUrl(url);
    }

    public void openBrowser(String browser, String url) {
        m_browser = browser;
        this.openBrowser(url);
    }

    public void openNewTab() {
        ((JavascriptExecutor)((Object)m_driver)).executeScript("window.open();", new Object[0]);
    }

    public void goToUrl(String url) {
        m_driver.get(url);
    }

    public void closeWindowIndex(int index) {
        ArrayList<String> windowHandles = new ArrayList<String>(m_driver.getWindowHandles());
        if (windowHandles.size() == 1) {
            this.closeBrowser();
        } else {
            m_driver.switchTo().window((String)windowHandles.get(index)).close();
        }
    }

    public void closeBrowser() {
        m_driver.quit();
        m_instance = null;
    }
}

