/*
 * Decompiled with CFR 0.152.
 */
package org.ndviet.library.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileHelpers {
    public static String getPath(String path) {
        if (path != null) {
            File file = new File(path);
            return file.getPath();
        }
        return path;
    }

    public static String getFileName(String path) {
        String filePath = FileHelpers.getPath(path);
        return filePath.substring(filePath.lastIndexOf(File.separator) + 1);
    }

    public static boolean isDirectory(String path) {
        return FileHelpers.isDirectory(path, true);
    }

    public static boolean isDirectory(String path, boolean createIfNotExist) {
        File file = new File(path);
        if (!file.exists() && createIfNotExist) {
            return file.mkdirs();
        }
        return file.isDirectory();
    }

    public static List<String> recursiveGetListFiles(String directory, List<String> allFiles) {
        File loadFile = new File(directory);
        File[] files = loadFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    FileHelpers.recursiveGetListFiles(directory, allFiles);
                    continue;
                }
                allFiles.add(file.getPath());
            }
        } else {
            allFiles.add(loadFile.getPath());
        }
        return allFiles;
    }

    public static List<String> recursiveGetListFiles(String directory, List<String> allFiles, String filterFileType) {
        FileHelpers.recursiveGetListFiles(directory, allFiles);
        ArrayList<String> filteredFiles = new ArrayList<String>();
        for (String filePath : allFiles) {
            if (filePath.lastIndexOf(".") > 0) {
                String fileExtension = filePath.substring(filePath.lastIndexOf(".") + 1);
                if (!fileExtension.toLowerCase().matches(filterFileType.toLowerCase())) continue;
                filteredFiles.add(filePath);
                continue;
            }
            if (!filePath.matches(filterFileType)) continue;
            filteredFiles.add(filePath);
        }
        return filteredFiles;
    }
}

