/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.dom;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v108.dom.model.AttributeModified;
import org.openqa.selenium.devtools.v108.dom.model.AttributeRemoved;
import org.openqa.selenium.devtools.v108.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v108.dom.model.BoxModel;
import org.openqa.selenium.devtools.v108.dom.model.CSSComputedStyleProperty;
import org.openqa.selenium.devtools.v108.dom.model.CharacterDataModified;
import org.openqa.selenium.devtools.v108.dom.model.ChildNodeCountUpdated;
import org.openqa.selenium.devtools.v108.dom.model.ChildNodeInserted;
import org.openqa.selenium.devtools.v108.dom.model.ChildNodeRemoved;
import org.openqa.selenium.devtools.v108.dom.model.DistributedNodesUpdated;
import org.openqa.selenium.devtools.v108.dom.model.Node;
import org.openqa.selenium.devtools.v108.dom.model.NodeId;
import org.openqa.selenium.devtools.v108.dom.model.PseudoElementAdded;
import org.openqa.selenium.devtools.v108.dom.model.PseudoElementRemoved;
import org.openqa.selenium.devtools.v108.dom.model.Quad;
import org.openqa.selenium.devtools.v108.dom.model.Rect;
import org.openqa.selenium.devtools.v108.dom.model.SetChildNodes;
import org.openqa.selenium.devtools.v108.dom.model.ShadowRootPopped;
import org.openqa.selenium.devtools.v108.dom.model.ShadowRootPushed;
import org.openqa.selenium.devtools.v108.page.model.FrameId;
import org.openqa.selenium.devtools.v108.runtime.model.ExecutionContextId;
import org.openqa.selenium.devtools.v108.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v108.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.v108.runtime.model.StackTrace;
import org.openqa.selenium.json.JsonInput;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

public class DOM {
    @Beta
    public static Command<List<String>> collectClassNamesFromSubtree(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<List<String>>("DOM.collectClassNamesFromSubtree", params.build(), ConverterFunctions.map("classNames", new TypeToken<List<String>>(){}.getType()));
    }

    @Beta
    public static Command<NodeId> copyTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("targetNodeId", targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put("insertBeforeNodeId", (NodeId)p));
        return new Command<NodeId>("DOM.copyTo", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<Node> describeNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        depth.ifPresent(p -> params.put("depth", p));
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command<Node>("DOM.describeNode", params.build(), ConverterFunctions.map("node", Node.class));
    }

    @Beta
    public static Command<Void> scrollIntoViewIfNeeded(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<Rect> rect) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        rect.ifPresent(p -> params.put("rect", p));
        return new Command<Void>("DOM.scrollIntoViewIfNeeded", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.disable", params.build());
    }

    @Beta
    public static Command<Void> discardSearchResults(String searchId) {
        Objects.requireNonNull(searchId, "searchId is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("searchId", searchId);
        return new Command<Void>("DOM.discardSearchResults", params.build());
    }

    public static Command<Void> enable(Optional<EnableIncludeWhitespace> includeWhitespace) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        includeWhitespace.ifPresent(p -> params.put("includeWhitespace", p));
        return new Command<Void>("DOM.enable", params.build());
    }

    public static Command<Void> focus(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<Void>("DOM.focus", params.build());
    }

    public static Command<List<String>> getAttributes(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<List<String>>("DOM.getAttributes", params.build(), ConverterFunctions.map("attributes", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<BoxModel> getBoxModel(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<BoxModel>("DOM.getBoxModel", params.build(), ConverterFunctions.map("model", BoxModel.class));
    }

    @Beta
    public static Command<List<Quad>> getContentQuads(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<List<Quad>>("DOM.getContentQuads", params.build(), ConverterFunctions.map("quads", new TypeToken<List<Quad>>(){}.getType()));
    }

    public static Command<Node> getDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put("depth", p));
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command<Node>("DOM.getDocument", params.build(), ConverterFunctions.map("root", Node.class));
    }

    @Deprecated
    public static Command<List<Node>> getFlattenedDocument(Optional<Integer> depth, Optional<Boolean> pierce) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        depth.ifPresent(p -> params.put("depth", p));
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command<List<Node>>("DOM.getFlattenedDocument", params.build(), ConverterFunctions.map("nodes", new TypeToken<List<Node>>(){}.getType()));
    }

    @Beta
    public static Command<List<NodeId>> getNodesForSubtreeByStyle(NodeId nodeId, List<CSSComputedStyleProperty> computedStyles, Optional<Boolean> pierce) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(computedStyles, "computedStyles is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("computedStyles", computedStyles);
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command<List<NodeId>>("DOM.getNodesForSubtreeByStyle", params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<GetNodeForLocationResponse> getNodeForLocation(Integer x, Integer y, Optional<Boolean> includeUserAgentShadowDOM, Optional<Boolean> ignorePointerEventsNone) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        ImmutableMap.Builder<String, Integer> params = ImmutableMap.builder();
        params.put("x", x);
        params.put("y", y);
        includeUserAgentShadowDOM.ifPresent(p -> params.put("includeUserAgentShadowDOM", (Integer)p));
        ignorePointerEventsNone.ifPresent(p -> params.put("ignorePointerEventsNone", (Integer)p));
        return new Command<GetNodeForLocationResponse>("DOM.getNodeForLocation", params.build(), input -> (GetNodeForLocationResponse)input.read((Type)((Object)GetNodeForLocationResponse.class)));
    }

    public static Command<String> getOuterHTML(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectId.ifPresent(p -> params.put("objectId", p));
        return new Command<String>("DOM.getOuterHTML", params.build(), ConverterFunctions.map("outerHTML", String.class));
    }

    @Beta
    public static Command<NodeId> getRelayoutBoundary(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<NodeId>("DOM.getRelayoutBoundary", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> getSearchResults(String searchId, Integer fromIndex, Integer toIndex) {
        Objects.requireNonNull(searchId, "searchId is required");
        Objects.requireNonNull(fromIndex, "fromIndex is required");
        Objects.requireNonNull(toIndex, "toIndex is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("searchId", searchId);
        params.put("fromIndex", fromIndex);
        params.put("toIndex", toIndex);
        return new Command<List<NodeId>>("DOM.getSearchResults", params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<Void> hideHighlight() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.hideHighlight", params.build());
    }

    public static Command<Void> highlightNode() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.highlightNode", params.build());
    }

    public static Command<Void> highlightRect() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.highlightRect", params.build());
    }

    @Beta
    public static Command<Void> markUndoableState() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.markUndoableState", params.build());
    }

    public static Command<NodeId> moveTo(NodeId nodeId, NodeId targetNodeId, Optional<NodeId> insertBeforeNodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(targetNodeId, "targetNodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("targetNodeId", targetNodeId);
        insertBeforeNodeId.ifPresent(p -> params.put("insertBeforeNodeId", (NodeId)p));
        return new Command<NodeId>("DOM.moveTo", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    @Beta
    public static Command<PerformSearchResponse> performSearch(String query, Optional<Boolean> includeUserAgentShadowDOM) {
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("query", query);
        includeUserAgentShadowDOM.ifPresent(p -> params.put("includeUserAgentShadowDOM", (String)p));
        return new Command<PerformSearchResponse>("DOM.performSearch", params.build(), input -> (PerformSearchResponse)input.read((Type)((Object)PerformSearchResponse.class)));
    }

    @Beta
    public static Command<NodeId> pushNodeByPathToFrontend(String path) {
        Objects.requireNonNull(path, "path is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("path", path);
        return new Command<NodeId>("DOM.pushNodeByPathToFrontend", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> pushNodesByBackendIdsToFrontend(List<BackendNodeId> backendNodeIds) {
        Objects.requireNonNull(backendNodeIds, "backendNodeIds is required");
        ImmutableMap.Builder<String, List<BackendNodeId>> params = ImmutableMap.builder();
        params.put("backendNodeIds", backendNodeIds);
        return new Command<List<NodeId>>("DOM.pushNodesByBackendIdsToFrontend", params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Command<NodeId> querySelector(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("selector", selector);
        return new Command<NodeId>("DOM.querySelector", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<List<NodeId>> querySelectorAll(NodeId nodeId, String selector) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(selector, "selector is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("selector", selector);
        return new Command<List<NodeId>>("DOM.querySelectorAll", params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    @Beta
    public static Command<List<NodeId>> getTopLayerElements() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<NodeId>>("DOM.getTopLayerElements", params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    @Beta
    public static Command<Void> redo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.redo", params.build());
    }

    public static Command<Void> removeAttribute(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("name", name);
        return new Command<Void>("DOM.removeAttribute", params.build());
    }

    public static Command<Void> removeNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<Void>("DOM.removeNode", params.build());
    }

    public static Command<Void> requestChildNodes(NodeId nodeId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        depth.ifPresent(p -> params.put("depth", (NodeId)p));
        pierce.ifPresent(p -> params.put("pierce", (NodeId)p));
        return new Command<Void>("DOM.requestChildNodes", params.build());
    }

    public static Command<NodeId> requestNode(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("objectId", objectId);
        return new Command<NodeId>("DOM.requestNode", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<RemoteObject> resolveNode(Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<String> objectGroup, Optional<ExecutionContextId> executionContextId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        nodeId.ifPresent(p -> params.put("nodeId", p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", p));
        objectGroup.ifPresent(p -> params.put("objectGroup", p));
        executionContextId.ifPresent(p -> params.put("executionContextId", p));
        return new Command<RemoteObject>("DOM.resolveNode", params.build(), ConverterFunctions.map("object", RemoteObject.class));
    }

    public static Command<Void> setAttributeValue(NodeId nodeId, String name, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("name", name);
        params.put("value", value);
        return new Command<Void>("DOM.setAttributeValue", params.build());
    }

    public static Command<Void> setAttributesAsText(NodeId nodeId, String text, Optional<String> name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(text, "text is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("text", text);
        name.ifPresent(p -> params.put("name", p));
        return new Command<Void>("DOM.setAttributesAsText", params.build());
    }

    public static Command<Void> setFileInputFiles(List<String> files, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId) {
        Objects.requireNonNull(files, "files is required");
        ImmutableMap.Builder<String, List<String>> params = ImmutableMap.builder();
        params.put("files", files);
        nodeId.ifPresent(p -> params.put("nodeId", (List<String>)p));
        backendNodeId.ifPresent(p -> params.put("backendNodeId", (List<String>)p));
        objectId.ifPresent(p -> params.put("objectId", (List<String>)p));
        return new Command<Void>("DOM.setFileInputFiles", params.build());
    }

    @Beta
    public static Command<Void> setNodeStackTracesEnabled(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enable", enable);
        return new Command<Void>("DOM.setNodeStackTracesEnabled", params.build());
    }

    @Beta
    public static Command<StackTrace> getNodeStackTraces(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<StackTrace>("DOM.getNodeStackTraces", params.build(), ConverterFunctions.map("creation", StackTrace.class));
    }

    @Beta
    public static Command<String> getFileInfo(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("objectId", objectId);
        return new Command<String>("DOM.getFileInfo", params.build(), ConverterFunctions.map("path", String.class));
    }

    @Beta
    public static Command<Void> setInspectedNode(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<Void>("DOM.setInspectedNode", params.build());
    }

    public static Command<NodeId> setNodeName(NodeId nodeId, String name) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("name", name);
        return new Command<NodeId>("DOM.setNodeName", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Command<Void> setNodeValue(NodeId nodeId, String value) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("value", value);
        return new Command<Void>("DOM.setNodeValue", params.build());
    }

    public static Command<Void> setOuterHTML(NodeId nodeId, String outerHTML) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(outerHTML, "outerHTML is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("outerHTML", outerHTML);
        return new Command<Void>("DOM.setOuterHTML", params.build());
    }

    @Beta
    public static Command<Void> undo() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("DOM.undo", params.build());
    }

    @Beta
    public static Command<GetFrameOwnerResponse> getFrameOwner(FrameId frameId) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder<String, FrameId> params = ImmutableMap.builder();
        params.put("frameId", frameId);
        return new Command<GetFrameOwnerResponse>("DOM.getFrameOwner", params.build(), input -> (GetFrameOwnerResponse)input.read((Type)((Object)GetFrameOwnerResponse.class)));
    }

    @Beta
    public static Command<NodeId> getContainerForNode(NodeId nodeId, Optional<String> containerName) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        containerName.ifPresent(p -> params.put("containerName", (NodeId)p));
        return new Command<NodeId>("DOM.getContainerForNode", params.build(), ConverterFunctions.map("nodeId", NodeId.class));
    }

    @Beta
    public static Command<List<NodeId>> getQueryingDescendantsForContainer(NodeId nodeId) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder<String, NodeId> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        return new Command<List<NodeId>>("DOM.getQueryingDescendantsForContainer", params.build(), ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Event<AttributeModified> attributeModified() {
        return new Event<AttributeModified>("DOM.attributeModified", input -> (AttributeModified)input.read((Type)((Object)AttributeModified.class)));
    }

    public static Event<AttributeRemoved> attributeRemoved() {
        return new Event<AttributeRemoved>("DOM.attributeRemoved", input -> (AttributeRemoved)input.read((Type)((Object)AttributeRemoved.class)));
    }

    public static Event<CharacterDataModified> characterDataModified() {
        return new Event<CharacterDataModified>("DOM.characterDataModified", input -> (CharacterDataModified)input.read((Type)((Object)CharacterDataModified.class)));
    }

    public static Event<ChildNodeCountUpdated> childNodeCountUpdated() {
        return new Event<ChildNodeCountUpdated>("DOM.childNodeCountUpdated", input -> (ChildNodeCountUpdated)input.read((Type)((Object)ChildNodeCountUpdated.class)));
    }

    public static Event<ChildNodeInserted> childNodeInserted() {
        return new Event<ChildNodeInserted>("DOM.childNodeInserted", input -> (ChildNodeInserted)input.read((Type)((Object)ChildNodeInserted.class)));
    }

    public static Event<ChildNodeRemoved> childNodeRemoved() {
        return new Event<ChildNodeRemoved>("DOM.childNodeRemoved", input -> (ChildNodeRemoved)input.read((Type)((Object)ChildNodeRemoved.class)));
    }

    public static Event<DistributedNodesUpdated> distributedNodesUpdated() {
        return new Event<DistributedNodesUpdated>("DOM.distributedNodesUpdated", input -> (DistributedNodesUpdated)input.read((Type)((Object)DistributedNodesUpdated.class)));
    }

    public static Event<Void> documentUpdated() {
        return new Event<Void>("DOM.documentUpdated", input -> null);
    }

    public static Event<List<NodeId>> inlineStyleInvalidated() {
        return new Event<List<NodeId>>("DOM.inlineStyleInvalidated", ConverterFunctions.map("nodeIds", new TypeToken<List<NodeId>>(){}.getType()));
    }

    public static Event<PseudoElementAdded> pseudoElementAdded() {
        return new Event<PseudoElementAdded>("DOM.pseudoElementAdded", input -> (PseudoElementAdded)input.read((Type)((Object)PseudoElementAdded.class)));
    }

    public static Event<Void> topLayerElementsUpdated() {
        return new Event<Void>("DOM.topLayerElementsUpdated", input -> null);
    }

    public static Event<PseudoElementRemoved> pseudoElementRemoved() {
        return new Event<PseudoElementRemoved>("DOM.pseudoElementRemoved", input -> (PseudoElementRemoved)input.read((Type)((Object)PseudoElementRemoved.class)));
    }

    public static Event<SetChildNodes> setChildNodes() {
        return new Event<SetChildNodes>("DOM.setChildNodes", input -> (SetChildNodes)input.read((Type)((Object)SetChildNodes.class)));
    }

    public static Event<ShadowRootPopped> shadowRootPopped() {
        return new Event<ShadowRootPopped>("DOM.shadowRootPopped", input -> (ShadowRootPopped)input.read((Type)((Object)ShadowRootPopped.class)));
    }

    public static Event<ShadowRootPushed> shadowRootPushed() {
        return new Event<ShadowRootPushed>("DOM.shadowRootPushed", input -> (ShadowRootPushed)input.read((Type)((Object)ShadowRootPushed.class)));
    }

    public static class GetFrameOwnerResponse {
        private final BackendNodeId backendNodeId;
        private final Optional<NodeId> nodeId;

        public GetFrameOwnerResponse(BackendNodeId backendNodeId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetFrameOwnerResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read((Type)((Object)BackendNodeId.class));
                        continue block8;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read((Type)((Object)NodeId.class)));
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetFrameOwnerResponse(backendNodeId, nodeId);
        }
    }

    public static class PerformSearchResponse {
        private final String searchId;
        private final Integer resultCount;

        public PerformSearchResponse(String searchId, Integer resultCount) {
            this.searchId = Objects.requireNonNull(searchId, "searchId is required");
            this.resultCount = Objects.requireNonNull(resultCount, "resultCount is required");
        }

        public String getSearchId() {
            return this.searchId;
        }

        public Integer getResultCount() {
            return this.resultCount;
        }

        private static PerformSearchResponse fromJson(JsonInput input) {
            String searchId = null;
            Integer resultCount = 0;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "searchId": {
                        searchId = input.nextString();
                        continue block8;
                    }
                    case "resultCount": {
                        resultCount = input.nextNumber().intValue();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new PerformSearchResponse(searchId, resultCount);
        }
    }

    public static class GetNodeForLocationResponse {
        private final BackendNodeId backendNodeId;
        private final FrameId frameId;
        private final Optional<NodeId> nodeId;

        public GetNodeForLocationResponse(BackendNodeId backendNodeId, FrameId frameId, Optional<NodeId> nodeId) {
            this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
            this.frameId = Objects.requireNonNull(frameId, "frameId is required");
            this.nodeId = nodeId;
        }

        public BackendNodeId getBackendNodeId() {
            return this.backendNodeId;
        }

        public FrameId getFrameId() {
            return this.frameId;
        }

        public Optional<NodeId> getNodeId() {
            return this.nodeId;
        }

        private static GetNodeForLocationResponse fromJson(JsonInput input) {
            BackendNodeId backendNodeId = null;
            FrameId frameId = null;
            Optional<NodeId> nodeId = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "backendNodeId": {
                        backendNodeId = (BackendNodeId)input.read((Type)((Object)BackendNodeId.class));
                        continue block10;
                    }
                    case "frameId": {
                        frameId = (FrameId)input.read((Type)((Object)FrameId.class));
                        continue block10;
                    }
                    case "nodeId": {
                        nodeId = Optional.ofNullable((NodeId)input.read((Type)((Object)NodeId.class)));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetNodeForLocationResponse(backendNodeId, frameId, nodeId);
        }
    }

    public static enum EnableIncludeWhitespace {
        NONE("none"),
        ALL("all");

        private String value;

        private EnableIncludeWhitespace(String value) {
            this.value = value;
        }

        public static EnableIncludeWhitespace fromString(String s2) {
            return Arrays.stream(EnableIncludeWhitespace.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within EnableIncludeWhitespace "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EnableIncludeWhitespace fromJson(JsonInput input) {
            return EnableIncludeWhitespace.fromString(input.nextString());
        }
    }
}

