/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.heapprofiler;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v108.heapprofiler.model.HeapSnapshotObjectId;
import org.openqa.selenium.devtools.v108.heapprofiler.model.LastSeenObjectId;
import org.openqa.selenium.devtools.v108.heapprofiler.model.ReportHeapSnapshotProgress;
import org.openqa.selenium.devtools.v108.heapprofiler.model.SamplingHeapProfile;
import org.openqa.selenium.devtools.v108.runtime.model.RemoteObject;
import org.openqa.selenium.devtools.v108.runtime.model.RemoteObjectId;
import shaded.com.google.common.collect.ImmutableMap;
import shaded.com.google.common.reflect.TypeToken;

@Beta
public class HeapProfiler {
    public static Command<Void> addInspectedHeapObject(HeapSnapshotObjectId heapObjectId) {
        Objects.requireNonNull(heapObjectId, "heapObjectId is required");
        ImmutableMap.Builder<String, HeapSnapshotObjectId> params = ImmutableMap.builder();
        params.put("heapObjectId", heapObjectId);
        return new Command<Void>("HeapProfiler.addInspectedHeapObject", params.build());
    }

    public static Command<Void> collectGarbage() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeapProfiler.collectGarbage", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeapProfiler.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("HeapProfiler.enable", params.build());
    }

    public static Command<HeapSnapshotObjectId> getHeapObjectId(RemoteObjectId objectId) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("objectId", objectId);
        return new Command<HeapSnapshotObjectId>("HeapProfiler.getHeapObjectId", params.build(), ConverterFunctions.map("heapSnapshotObjectId", HeapSnapshotObjectId.class));
    }

    public static Command<RemoteObject> getObjectByHeapObjectId(HeapSnapshotObjectId objectId, Optional<String> objectGroup) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder<String, HeapSnapshotObjectId> params = ImmutableMap.builder();
        params.put("objectId", objectId);
        objectGroup.ifPresent(p -> params.put("objectGroup", (HeapSnapshotObjectId)p));
        return new Command<RemoteObject>("HeapProfiler.getObjectByHeapObjectId", params.build(), ConverterFunctions.map("result", RemoteObject.class));
    }

    public static Command<SamplingHeapProfile> getSamplingProfile() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingHeapProfile>("HeapProfiler.getSamplingProfile", params.build(), ConverterFunctions.map("profile", SamplingHeapProfile.class));
    }

    public static Command<Void> startSampling(Optional<Number> samplingInterval, Optional<Boolean> includeObjectsCollectedByMajorGC, Optional<Boolean> includeObjectsCollectedByMinorGC) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        samplingInterval.ifPresent(p -> params.put("samplingInterval", p));
        includeObjectsCollectedByMajorGC.ifPresent(p -> params.put("includeObjectsCollectedByMajorGC", p));
        includeObjectsCollectedByMinorGC.ifPresent(p -> params.put("includeObjectsCollectedByMinorGC", p));
        return new Command<Void>("HeapProfiler.startSampling", params.build());
    }

    public static Command<Void> startTrackingHeapObjects(Optional<Boolean> trackAllocations) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        trackAllocations.ifPresent(p -> params.put("trackAllocations", p));
        return new Command<Void>("HeapProfiler.startTrackingHeapObjects", params.build());
    }

    public static Command<SamplingHeapProfile> stopSampling() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<SamplingHeapProfile>("HeapProfiler.stopSampling", params.build(), ConverterFunctions.map("profile", SamplingHeapProfile.class));
    }

    public static Command<Void> stopTrackingHeapObjects(Optional<Boolean> reportProgress, Optional<Boolean> treatGlobalObjectsAsRoots, Optional<Boolean> captureNumericValue, Optional<Boolean> exposeInternals) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        reportProgress.ifPresent(p -> params.put("reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put("treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put("captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put("exposeInternals", p));
        return new Command<Void>("HeapProfiler.stopTrackingHeapObjects", params.build());
    }

    public static Command<Void> takeHeapSnapshot(Optional<Boolean> reportProgress, Optional<Boolean> treatGlobalObjectsAsRoots, Optional<Boolean> captureNumericValue, Optional<Boolean> exposeInternals) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        reportProgress.ifPresent(p -> params.put("reportProgress", p));
        treatGlobalObjectsAsRoots.ifPresent(p -> params.put("treatGlobalObjectsAsRoots", p));
        captureNumericValue.ifPresent(p -> params.put("captureNumericValue", p));
        exposeInternals.ifPresent(p -> params.put("exposeInternals", p));
        return new Command<Void>("HeapProfiler.takeHeapSnapshot", params.build());
    }

    public static Event<String> addHeapSnapshotChunk() {
        return new Event<String>("HeapProfiler.addHeapSnapshotChunk", ConverterFunctions.map("chunk", String.class));
    }

    public static Event<List<Integer>> heapStatsUpdate() {
        return new Event<List<Integer>>("HeapProfiler.heapStatsUpdate", ConverterFunctions.map("statsUpdate", new TypeToken<List<Integer>>(){}.getType()));
    }

    public static Event<LastSeenObjectId> lastSeenObjectId() {
        return new Event<LastSeenObjectId>("HeapProfiler.lastSeenObjectId", input -> (LastSeenObjectId)input.read((Type)((Object)LastSeenObjectId.class)));
    }

    public static Event<ReportHeapSnapshotProgress> reportHeapSnapshotProgress() {
        return new Event<ReportHeapSnapshotProgress>("HeapProfiler.reportHeapSnapshotProgress", input -> (ReportHeapSnapshotProgress)input.read((Type)((Object)ReportHeapSnapshotProgress.class)));
    }

    public static Event<Void> resetProfiles() {
        return new Event<Void>("HeapProfiler.resetProfiles", input -> null);
    }
}

